/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.SupposeBackground;
import org.androidannotations.api.BackgroundExecutor;
import org.androidannotations.handler.SupposeThreadHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;

public class SupposeBackgroundHandler
extends SupposeThreadHandler {
    private static final String METHOD_CHECK_BG_THREAD = "checkBgThread";
    private final APTCodeModelHelper helper = new APTCodeModelHelper();

    public SupposeBackgroundHandler(ProcessingEnvironment processingEnvironment) {
        super(SupposeBackground.class, processingEnvironment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.helper.overrideAnnotatedMethod(executableElement, holder);
        JClass bgExecutor = this.refClass(BackgroundExecutor.class);
        SupposeBackground annotation = element.getAnnotation(SupposeBackground.class);
        String[] serial = annotation.serial();
        JInvocation invocation = bgExecutor.staticInvoke(METHOD_CHECK_BG_THREAD);
        for (String s : serial) {
            invocation.arg(JExpr.lit(s));
        }
        JBlock body = delegatingMethod.body();
        body.pos(0);
        body.add(invocation);
        body.pos(body.getContents().size());
    }
}

