/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apithefire.sql.connect;

import org.apithefire.util.lang.Builder;

/**
 * A {@link ConnectionPool} is a cache of database connections.
 * 
 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
 */
public interface ConnectionPool extends ConnectionProvider {
	
	/**
	 * A {@link ConnectionPool} builder.
	 * 
	 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
	 */
	public interface ConnectionPoolBuilder extends Builder {
		
		/**
		 * Sets the underlying connection provider.
		 * 
		 * @return this builder
		 */
		public ConnectionPoolBuilder setConnectionProvider(
				ConnectionProvider connectionProvider);
		
		/**
		 * Sets minimum connection pool size.
		 * 
		 * @return this builder
		 */
		public ConnectionPoolBuilder setMinPoolSize(int minPoolSize);
		
		/**
		 * Sets maximum connection pool size.
		 * 
		 * @return this builder
		 */
		public ConnectionPoolBuilder setMaxPoolSize(int maxPoolSize);
		
		/**
		 * Builds a new {@link ConnectionPool}.
		 * 
		 * @return the built {@link ConnectionPool}
		 */
		public ConnectionPool build();
		
	}
	
	/**
	 * Returns minimum connection pool size.
	 */
	public int getMinPoolSize();
	
	/**
	 * Returns maximum connection pool size.
	 */
	public int getMaxPoolSize();
	
	/**
	 * Close all connections of this connection pool.
	 */
	public void close();
	
}
