/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apithefire.sql.connect;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.apithefire.sql.RuntimeSqlException;
import org.apithefire.util.lang.Objects;

/**
 * A {@link ConnectionProvider} wrapper to provide {@link DataSource} interface.
 * 
 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
 */
// TODO: Class name is confusing
public abstract class DataSourceWrapper implements ConnectionProvider {
	
	private final DataSource dataSource;
	
	public DataSourceWrapper(DataSource dataSource) {
		this.dataSource = Objects.nonNull(dataSource);
	}
	
	protected DataSource getWrappedDataSource() {
		return dataSource;
	}

	public Connection getConnection() {
		try {
			return dataSource.getConnection();
		} catch (SQLException e) {
			throw new RuntimeSqlException(e);
		}
	}

}
