/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.sequencing.io.fastq;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.features.QualityFeature;
import org.biojava.nbio.core.sequence.features.QuantityFeature;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.sequencing.io.fastq.Fastq;
import org.biojava.nbio.sequencing.io.fastq.FastqVariant;

public final class FastqTools {
    private FastqTools() {
    }

    public static DNASequence createDNASequence(Fastq fastq) throws CompoundNotFoundException {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        DNASequence sequence = new DNASequence(fastq.getSequence());
        sequence.setOriginalHeader(fastq.getDescription());
        return sequence;
    }

    public static DNASequence createDNASequenceWithQualityScores(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createQualityScores(fastq));
        return sequence;
    }

    public static DNASequence createDNASequenceWithErrorProbabilities(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createErrorProbabilities(fastq));
        return sequence;
    }

    public static DNASequence createDNASequenceWithQualityScoresAndErrorProbabilities(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createQualityScores(fastq));
        sequence.addFeature(1, sequence.getLength(), FastqTools.createErrorProbabilities(fastq));
        return sequence;
    }

    public static QualityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> createQualityScores(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        QualityFeature qualityScores = new QualityFeature("qualityScores", "sequencing");
        qualityScores.setQualities(FastqTools.toList(FastqTools.qualityScores(fastq)));
        return qualityScores;
    }

    public static QuantityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> createErrorProbabilities(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        QuantityFeature errorProbabilities = new QuantityFeature("errorProbabilities", "sequencing");
        errorProbabilities.setQuantities(FastqTools.toList(FastqTools.errorProbabilities(fastq)));
        return errorProbabilities;
    }

    public static Iterable<Number> qualityScores(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        int size = fastq.getQuality().length();
        ArrayList qualityScores = Lists.newArrayListWithExpectedSize((int)size);
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            qualityScores.add(variant.qualityScore(c));
        }
        return ImmutableList.copyOf((Collection)qualityScores);
    }

    public static int[] qualityScores(Fastq fastq, int[] qualityScores) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (qualityScores == null) {
            throw new IllegalArgumentException("qualityScores must not be null");
        }
        int size = fastq.getQuality().length();
        if (qualityScores.length != size) {
            throw new IllegalArgumentException("qualityScores must be the same length as the FASTQ formatted sequence quality");
        }
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            qualityScores[i] = variant.qualityScore(c);
        }
        return qualityScores;
    }

    public static Iterable<Number> errorProbabilities(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        int size = fastq.getQuality().length();
        ArrayList errorProbabilities = Lists.newArrayListWithExpectedSize((int)size);
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            errorProbabilities.add(variant.errorProbability(c));
        }
        return ImmutableList.copyOf((Collection)errorProbabilities);
    }

    public static double[] errorProbabilities(Fastq fastq, double[] errorProbabilities) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (errorProbabilities == null) {
            throw new IllegalArgumentException("errorProbabilities must not be null");
        }
        int size = fastq.getQuality().length();
        if (errorProbabilities.length != size) {
            throw new IllegalArgumentException("errorProbabilities must be the same length as the FASTQ formatted sequence quality");
        }
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            errorProbabilities[i] = variant.errorProbability(c);
        }
        return errorProbabilities;
    }

    static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return ImmutableList.copyOf(iterable);
    }
}

