/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.Locale;
import org.biojava.nbio.structure.PDBRecord;
import org.biojava.nbio.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRef
implements PDBRecord {
    private static final Logger logger = LoggerFactory.getLogger(DBRef.class);
    private static final long serialVersionUID = -1050178577542224379L;
    private Structure parent;
    private String idCode;
    private String chainId;
    private int seqbegin;
    private char insertBegin = (char)32;
    private int seqEnd;
    private char insertEnd = (char)32;
    private String database;
    private String dbAccession;
    private String dbIdCode;
    private int dbSeqBegin;
    private char idbnsBegin = (char)32;
    private int dbSeqEnd;
    private char idbnsEnd = (char)32;
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParent(Structure s) {
        this.parent = s;
    }

    public Structure getParent() {
        return this.parent;
    }

    @Override
    public String toPDB() {
        StringBuffer buf = new StringBuffer();
        this.toPDB(buf);
        return buf.toString();
    }

    @Override
    public void toPDB(StringBuffer buf) {
        Formatter formatter = new Formatter(new StringBuilder(), Locale.UK);
        formatter.format("DBREF  %4s %1s %4d%1s %4d%1s %-6s %-8s %-12s%6d%1c%6d%1c            ", this.idCode, this.chainId, this.seqbegin, Character.valueOf(this.insertBegin), this.seqEnd, Character.valueOf(this.insertEnd), this.database, this.dbAccession, this.dbIdCode, this.dbSeqBegin, Character.valueOf(this.idbnsBegin), this.dbSeqEnd, Character.valueOf(this.idbnsEnd));
        buf.append(formatter.toString());
        formatter.close();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            Method[] methods;
            Class<?> c = Class.forName(DBRef.class.getName());
            for (Method m : methods = c.getMethods()) {
                Object o;
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass") || (o = m.invoke((Object)this, new Object[0])) == null) continue;
                buf.append(name.substring(3, name.length()));
                buf.append(": ").append(o).append(" ");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return buf.toString();
    }

    public String getIdCode() {
        return this.idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDbAccession() {
        return this.dbAccession;
    }

    public void setDbAccession(String dbAccession) {
        this.dbAccession = dbAccession;
    }

    public String getDbIdCode() {
        return this.dbIdCode;
    }

    public void setDbIdCode(String dbIdCode) {
        this.dbIdCode = dbIdCode;
    }

    public int getDbSeqBegin() {
        return this.dbSeqBegin;
    }

    public void setDbSeqBegin(int dbSeqBegin) {
        this.dbSeqBegin = dbSeqBegin;
    }

    public int getDbSeqEnd() {
        return this.dbSeqEnd;
    }

    public void setDbSeqEnd(int dbSeqEnd) {
        this.dbSeqEnd = dbSeqEnd;
    }

    public char getIdbnsBegin() {
        return this.idbnsBegin;
    }

    public void setIdbnsBegin(char idbnsBegin) {
        this.idbnsBegin = idbnsBegin;
    }

    public char getIdbnsEnd() {
        return this.idbnsEnd;
    }

    public void setIdbnsEnd(char idbnsEnd) {
        this.idbnsEnd = idbnsEnd;
    }

    public char getInsertBegin() {
        return this.insertBegin;
    }

    public void setInsertBegin(char insertBegin) {
        this.insertBegin = insertBegin;
    }

    public char getInsertEnd() {
        return this.insertEnd;
    }

    public void setInsertEnd(char insertEnd) {
        this.insertEnd = insertEnd;
    }

    public int getSeqBegin() {
        return this.seqbegin;
    }

    public void setSeqBegin(int seqbegin) {
        this.seqbegin = seqbegin;
    }

    public int getSeqEnd() {
        return this.seqEnd;
    }

    public void setSeqEnd(int seqEnd) {
        this.seqEnd = seqEnd;
    }
}

