/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.pairwise;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StrucAligParameters;
import org.biojava.nbio.structure.align.helper.AlignTools;
import org.biojava.nbio.structure.align.helper.JointFragments;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.align.pairwise.FragmentPair;
import org.biojava.nbio.structure.align.pairwise.JointFragmentsComparator;
import org.biojava.nbio.structure.jama.Matrix;

public class FragmentJoiner {
    public static Logger logger = Logger.getLogger("org.biojava.nbio.structure.align");

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static boolean reduceFragments(List<FragmentPair> fragments, FragmentPair f, Matrix rmsmat) {
        boolean doNotAdd = false;
        int i = f.getPos1();
        int j = f.getPos2();
        for (int p = 0; p < fragments.size(); ++p) {
            int di2;
            FragmentPair tmp = fragments.get(p);
            int di1 = Math.abs(f.getPos1() - tmp.getPos1());
            if (Math.abs(di1 - (di2 = Math.abs(f.getPos2() - tmp.getPos2()))) != 2) continue;
            double rms1 = rmsmat.get(tmp.getPos1(), tmp.getPos2());
            double rms2 = rmsmat.get(i, j);
            doNotAdd = true;
            if (rms2 < rms1) {
                fragments.remove(p);
                fragments.add(f);
                break;
            }
            p = fragments.size();
        }
        return doNotAdd;
    }

    public JointFragments[] approach_ap3(Atom[] ca1, Atom[] ca2, FragmentPair[] fraglst, StrucAligParameters params) throws StructureException {
        ArrayList<JointFragments> fll = new ArrayList<JointFragments>();
        FragmentPair[] tmpfidx = new FragmentPair[fraglst.length];
        for (int i = 0; i < fraglst.length; ++i) {
            tmpfidx[i] = (FragmentPair)fraglst[i].clone();
        }
        int n = tmpfidx.length;
        for (int i = 0; i < fraglst.length; ++i) {
            boolean[] used = new boolean[n];
            int p1i = tmpfidx[i].getPos1();
            int p1j = tmpfidx[i].getPos2();
            int l1 = tmpfidx[i].getLength();
            JointFragments f = new JointFragments();
            int maxi = p1i + l1 - 1;
            f.add(p1i, p1j, 0, l1);
            used[i] = true;
            for (int j = i + 1; j < n; ++j) {
                if (used[j]) continue;
                int p2i = tmpfidx[j].getPos1();
                int p2j = tmpfidx[j].getPos2();
                int l2 = tmpfidx[j].getLength();
                if (p2i <= maxi || params.isDoAngleCheck() && !this.angleCheckOk(tmpfidx[i], tmpfidx[j], 0.4f) || params.isDoDistanceCheck() && !this.distanceCheckOk(tmpfidx[i], tmpfidx[j], params.getFragmentMiniDistance()) || params.isDoDensityCheck() && !this.densityCheckOk(ca1, ca2, f.getIdxlist(), p2i, p2j, l2, params.getDensityCutoff())) continue;
                if (params.isDoRMSCheck()) {
                    double rms = this.rmsCheck(ca1, ca2, f.getIdxlist(), p2i, p2j, l2);
                    if (rms > params.getJoinRMSCutoff()) continue;
                    f.setRms(rms);
                }
                f.add(p2i, p2j, 0, l2);
                used[j] = true;
                maxi = p2i + l2 - 1;
            }
            fll.add(f);
        }
        JointFragmentsComparator comp = new JointFragmentsComparator();
        Collections.sort(fll, comp);
        Collections.reverse(fll);
        int m = Math.min(params.getMaxrefine(), fll.size());
        ArrayList<JointFragments> retlst = new ArrayList<JointFragments>();
        for (int i = 0; i < m; ++i) {
            JointFragments jf = (JointFragments)fll.get(i);
            retlst.add(jf);
        }
        return retlst.toArray(new JointFragments[retlst.size()]);
    }

    private boolean densityCheckOk(Atom[] aa1, Atom[] aa2, List<int[]> idxlist, int p2i, int p2j, int l2, double densityCutoff) throws StructureException {
        JointFragments ftmp = new JointFragments();
        ftmp.setIdxlist(idxlist);
        ftmp.add(p2i, p2j, 0, l2);
        AlternativeAlignment ali = new AlternativeAlignment();
        ali.apairs_from_idxlst(ftmp);
        Atom[] aa3 = (Atom[])aa2.clone();
        int[] idx1 = ali.getIdx1();
        int[] idx2 = ali.getIdx2();
        Atom[] ca1subset = AlignTools.getFragmentFromIdxList(aa1, idx1);
        Atom[] ca2subset = AlignTools.getFragmentFromIdxList(aa3, idx2);
        double density = this.getDensity(ca1subset, ca2subset);
        return density <= densityCutoff;
    }

    private double getDensity(Atom[] ca1subset, Atom[] ca2subset) throws StructureException {
        Atom centroid1 = Calc.getCentroid(ca1subset);
        Atom centroid2 = Calc.getCentroid(ca2subset);
        double d1 = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < ca1subset.length; ++i) {
            double dd1 = Calc.getDistance(centroid1, ca1subset[i]);
            double dd2 = Calc.getDistance(centroid2, ca2subset[i]);
            d1 += dd1;
            d2 += dd2;
        }
        double avd1 = d1 / (double)ca1subset.length;
        double avd2 = d2 / (double)ca2subset.length;
        return Math.min(avd1, avd2);
    }

    private double rmsCheck(Atom[] a1, Atom[] a2, List<int[]> idxlist, int p2i, int p2j, int l2) throws StructureException {
        JointFragments ftmp = new JointFragments();
        ftmp.setIdxlist(idxlist);
        ftmp.add(p2i, p2j, 0, l2);
        Atom[] a3 = new Atom[a2.length];
        for (int i = 0; i < a2.length; ++i) {
            a3[i] = (Atom)a2[i].clone();
        }
        return FragmentJoiner.getRMS(a1, a3, ftmp);
    }

    public static double getRMS(Atom[] ca1, Atom[] ca2, JointFragments frag) throws StructureException {
        AlternativeAlignment ali = new AlternativeAlignment();
        ali.apairs_from_idxlst(frag);
        double rms = 999.0;
        int[] idx1 = ali.getIdx1();
        int[] idx2 = ali.getIdx2();
        Atom[] ca1subset = AlignTools.getFragmentFromIdxList(ca1, idx1);
        Atom[] ca2subset = AlignTools.getFragmentFromIdxList(ca2, idx2);
        ali.calculateSuperpositionByIdx(ca1, ca2);
        Matrix rot = ali.getRotationMatrix();
        Atom atom = ali.getShift();
        for (Atom a : ca2subset) {
            Calc.rotate(a, rot);
            Calc.shift(a, atom);
        }
        rms = Calc.rmsd(ca1subset, ca2subset);
        return rms;
    }

    public boolean angleCheckOk(FragmentPair a, FragmentPair b, float distcutoff) {
        Atom v2;
        double dist = -999.0;
        Atom v1 = a.getUnitv();
        dist = Calc.getDistance(v1, v2 = b.getUnitv());
        return dist <= (double)distcutoff;
    }

    private boolean distanceCheckOk(FragmentPair a, FragmentPair b, float fragCompatDist) {
        Atom c1i = a.getCenter1();
        Atom c1j = b.getCenter1();
        Atom c2i = a.getCenter2();
        Atom c2j = b.getCenter2();
        double dd = Calc.getDistance(c1i, c1j) - Calc.getDistance(c2i, c2j);
        if (dd < 0.0) {
            dd = -dd;
        }
        return dd <= (double)fragCompatDist;
    }

    public JointFragments[] frag_pairwise_compat(FragmentPair[] fraglst, int angleDiff, float fragCompatDist, int maxRefine) {
        FragmentPair[] tmpfidx = new FragmentPair[fraglst.length];
        for (int i = 0; i < fraglst.length; ++i) {
            tmpfidx[i] = (FragmentPair)fraglst[i].clone();
        }
        int n = tmpfidx.length;
        int[] used = new int[n];
        ArrayList<JointFragments> fll = new ArrayList<JointFragments>();
        double adiff = (double)angleDiff * Math.PI / 180.0;
        logger.finer("addiff" + adiff);
        double ddiff = Math.sqrt(2.0 - 2.0 * Math.cos(adiff));
        logger.finer("ddiff" + ddiff);
        while (tmpfidx.length > 0) {
            int i = 0;
            used[i] = 1;
            JointFragments f = new JointFragments();
            int p1i = tmpfidx[i].getPos1();
            int p1j = tmpfidx[i].getPos2();
            int maxi = p1i + tmpfidx[i].getLength();
            f.add(p1i, p1j, 0, tmpfidx[i].getLength());
            n = tmpfidx.length;
            for (int j = 1; j < n; ++j) {
                double dist;
                int p2i = tmpfidx[j].getPos1();
                int p2j = tmpfidx[j].getPos2();
                int l2 = tmpfidx[j].getLength();
                if (p2i <= maxi || !((dist = Calc.getDistance(tmpfidx[i].getUnitv(), tmpfidx[j].getUnitv())) < ddiff)) continue;
                double dd = Calc.getDistance(tmpfidx[i].getCenter1(), tmpfidx[j].getCenter1()) - Calc.getDistance(tmpfidx[i].getCenter2(), tmpfidx[j].getCenter2());
                if (dd < 0.0) {
                    dd = -dd;
                }
                if (!(dd < (double)fragCompatDist)) continue;
                maxi = p2i + l2;
                used[j] = 1;
                f.add(p2i, p2j, 0, tmpfidx[j].getLength());
            }
            int red = 0;
            for (int k = 0; k < n; ++k) {
                if (used[k] != 0) continue;
                tmpfidx[red] = tmpfidx[k];
                ++red;
            }
            used = new int[n];
            tmpfidx = (FragmentPair[])FragmentJoiner.resizeArray(tmpfidx, red);
            fll.add(f);
        }
        JointFragmentsComparator comp = new JointFragmentsComparator();
        Collections.sort(fll, comp);
        Collections.reverse(fll);
        int m = Math.min(maxRefine, fll.size());
        ArrayList<JointFragments> retlst = new ArrayList<JointFragments>();
        for (int i = 0; i < m; ++i) {
            JointFragments jf = (JointFragments)fll.get(i);
            retlst.add(jf);
        }
        return retlst.toArray(new JointFragments[retlst.size()]);
    }

    public void extendFragments(Atom[] ca1, Atom[] ca2, JointFragments[] fragments, StrucAligParameters params) throws StructureException {
        for (JointFragments p : fragments) {
            this.extendFragments(ca1, ca2, p, params);
        }
    }

    public void extendFragments(Atom[] ca1, Atom[] ca2, JointFragments fragments, StrucAligParameters params) throws StructureException {
        List<int[]> pos = fragments.getIdxlist();
        int[] firstP = pos.get(0);
        int pstart1 = firstP[0];
        int pstart2 = firstP[1];
        int[] lastP = pos.get(pos.size() - 1);
        int pend1 = lastP[0];
        int pend2 = lastP[1];
        boolean startReached = false;
        boolean endReached = false;
        while (!startReached || !endReached) {
            if (!(startReached || pstart1 > 0 && pstart2 > 0)) {
                startReached = true;
            } else {
                --pstart1;
                --pstart2;
            }
            if (!(endReached || pend1 < ca1.length - 1 && pend2 < ca2.length - 1)) {
                endReached = true;
            } else {
                ++pend1;
                ++pend2;
            }
            if (!startReached) {
                double newRms1 = this.testAdd(ca1, ca2, fragments, pstart1, pstart2);
                if (newRms1 < 3.7) {
                    fragments.add(pstart1, pstart2, 0, 1);
                } else {
                    startReached = true;
                }
            }
            if (endReached) continue;
            double newRms2 = this.testAdd(ca1, ca2, fragments, pend1, pend2);
            if (newRms2 < 3.7) {
                fragments.add(pend1, pend2, 0, 1);
                continue;
            }
            endReached = true;
        }
    }

    private double testAdd(Atom[] ca1, Atom[] ca2, JointFragments fragments, int pstart1, int pstart2) throws StructureException {
        JointFragments frag = new JointFragments();
        frag.setIdxlist(fragments.getIdxlist());
        frag.add(pstart1, pstart2, 0, 1);
        return FragmentJoiner.getRMS(ca1, ca2, frag);
    }
}

