/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.GuiWrapper;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.geometry.Matrices;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFPAlignmentDisplay {
    private static final Logger logger = LoggerFactory.getLogger(AFPAlignmentDisplay.class);
    private static final int[][] aaMatrix = new int[][]{{6, 0, -2, -3, -2, 0, -1, 0, -2, -2, -2, -2, -2, -3, -4, -4, -3, -3, -3, -2, -4}, {0, 4, -1, 0, 0, 1, -2, -2, -1, -1, -1, -2, -1, 0, -1, -1, -1, -2, -2, -3, -4}, {-2, -1, 7, -3, -1, -1, -1, -2, -1, -1, -1, -2, -2, -2, -3, -3, -2, -4, -3, -4, -4}, {-3, 0, -3, 9, -1, -1, -3, -3, -4, -3, -3, -3, -3, -1, -1, -1, -1, -2, -2, -2, -4}, {-2, 0, -1, -1, 5, 1, -1, 0, -1, -1, -1, -2, -1, 0, -1, -1, -1, -2, -2, -2, -4}, {0, 1, -1, -1, 1, 4, 0, 1, 0, 0, 0, -1, -1, -2, -2, -2, -1, -2, -2, -3, -4}, {-1, -2, -1, -3, -1, 0, 6, 1, 2, 0, -1, -1, -2, -3, -3, -4, -3, -3, -3, -4, -4}, {0, -2, -2, -3, 0, 1, 1, 6, 0, 0, 0, 1, 0, -3, -3, -3, -2, -3, -2, -4, -4}, {-2, -1, -1, -4, -1, 0, 2, 0, 5, 2, 1, 0, 0, -2, -3, -3, -2, -3, -2, -3, -4}, {-2, -1, -1, -3, -1, 0, 0, 0, 2, 5, 1, 0, 1, -2, -3, -2, 0, -3, -1, -2, -4}, {-2, -1, -1, -3, -1, 0, -1, 0, 1, 1, 5, -1, 2, -2, -3, -2, -1, -3, -2, -3, -4}, {-2, -2, -2, -3, -2, -1, -1, 1, 0, 0, -1, 8, 0, -3, -3, -3, -2, -1, 2, -2, -4}, {-2, -1, -2, -3, -1, -1, -2, 0, 0, 1, 2, 0, 5, -3, -3, -2, -1, -3, -2, -3, -4}, {-3, 0, -2, -1, 0, -2, -3, -3, -2, -2, -2, -3, -3, 4, 3, 1, 1, -1, -1, -3, -4}, {-4, -1, -3, -1, -1, -2, -3, -3, -3, -3, -3, -3, -3, 3, 4, 2, 1, 0, -1, -3, -4}, {-4, -1, -3, -1, -1, -2, -4, -3, -3, -2, -2, -3, -2, 1, 2, 4, 2, 0, -1, -2, -4}, {-3, -1, -2, -1, -1, -1, -3, -2, -2, 0, -1, -2, -1, 1, 1, 2, 5, 0, -1, -1, -4}, {-3, -2, -4, -2, -2, -2, -3, -3, -3, -3, -3, -1, -3, -1, 0, 0, 0, 6, 3, 1, -4}, {-3, -2, -3, -2, -2, -2, -3, -2, -2, -1, -2, 2, -2, -1, -1, -1, -1, 3, 7, 2, -4}, {-2, -3, -4, -2, -2, -3, -4, -4, -3, -2, -3, -2, -3, -3, -3, -2, -1, 1, 2, 11, -4}, {-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1}};
    private static Character[] aa1 = new Character[]{Character.valueOf('G'), Character.valueOf('A'), Character.valueOf('P'), Character.valueOf('C'), Character.valueOf('T'), Character.valueOf('S'), Character.valueOf('D'), Character.valueOf('N'), Character.valueOf('E'), Character.valueOf('Q'), Character.valueOf('K'), Character.valueOf('H'), Character.valueOf('R'), Character.valueOf('V'), Character.valueOf('I'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('Y'), Character.valueOf('W'), Character.valueOf('-')};
    private static final List<Character> aa1List = Arrays.asList(aa1);

    public static Matrix getRotMax(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] a1 = AFPAlignmentDisplay.getAlignedAtoms1(afpChain, ca1);
        Atom[] a2 = AFPAlignmentDisplay.getAlignedAtoms2(afpChain, ca2);
        Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(a1), Calc.atomsToPoints(a2));
        return Matrices.getRotationJAMA(trans);
    }

    public static Atom getTranslation(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] a1 = AFPAlignmentDisplay.getAlignedAtoms1(afpChain, ca1);
        Atom[] a2 = AFPAlignmentDisplay.getAlignedAtoms2(afpChain, ca2);
        Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(a1), Calc.atomsToPoints(a2));
        return Calc.getTranslationVector(trans);
    }

    public static Atom[] getAlignedAtoms1(AFPChain afpChain, Atom[] ca1) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos = optAln[bk][0][i];
                atoms.add(ca1[pos]);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static Atom[] getAlignedAtoms2(AFPChain afpChain, Atom[] ca2) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos = optAln[bk][1][i];
                atoms.add(ca2[pos]);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static void getAlign(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        AFPAlignmentDisplay.getAlign(afpChain, ca1, ca2, false);
    }

    public static void getAlign(AFPChain afpChain, Atom[] ca1, Atom[] ca2, boolean showSeq) {
        char[] alnsymb = afpChain.getAlnsymb();
        char[] alnseq1 = afpChain.getAlnseq1();
        char[] alnseq2 = afpChain.getAlnseq2();
        int pro1Len = ca1.length;
        int pro2Len = ca2.length;
        int p2b = 0;
        int p1b = 0;
        if (alnsymb == null) {
            alnseq1 = new char[pro1Len + pro2Len + 1];
            alnseq2 = new char[pro1Len + pro2Len + 1];
            alnsymb = new char[pro1Len + pro2Len + 1];
            afpChain.setAlnseq1(alnseq1);
            afpChain.setAlnseq2(alnseq2);
            afpChain.setAlnsymb(alnsymb);
        }
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        int alnbeg1 = afpChain.getAlnbeg1();
        int alnbeg2 = afpChain.getAlnbeg2();
        int optLength = afpChain.getOptLength();
        if (optLen == null) {
            optLen = new int[blockNum];
            for (int oi = 0; oi < blockNum; ++oi) {
                optLen[oi] = 0;
            }
        }
        int len = 0;
        for (int i = 0; i < blockNum; ++i) {
            for (int j = 0; j < optLen[i]; ++j) {
                int p1 = optAln[i][0][j];
                int p2 = optAln[i][1][j];
                if (p1 == -1 || p2 == -1) {
                    logger.warn("Could not get atom on position " + j);
                    continue;
                }
                if (len > 0) {
                    int lmax = p1 - p1b - 1 > p2 - p2b - 1 ? p1 - p1b - 1 : p2 - p2b - 1;
                    for (int k = 0; k < lmax; ++k) {
                        char oneletter;
                        alnseq1[len] = k >= p1 - p1b - 1 ? 45 : (oneletter = AFPAlignmentDisplay.getOneLetter(ca1[p1b + 1 + k].getGroup()));
                        alnseq2[len] = k >= p2 - p2b - 1 ? 45 : (oneletter = AFPAlignmentDisplay.getOneLetter(ca2[p2b + 1 + k].getGroup()));
                        alnsymb[len++] = 32;
                    }
                } else {
                    alnbeg1 = p1;
                    alnbeg2 = p2;
                }
                if (p1 < ca1.length && p2 < ca2.length) {
                    alnseq1[len] = AFPAlignmentDisplay.getOneLetter(ca1[p1].getGroup());
                    alnseq2[len] = AFPAlignmentDisplay.getOneLetter(ca2[p2].getGroup());
                } else {
                    alnseq1[len] = 63;
                    alnseq2[len] = 63;
                }
                if (showSeq) {
                    double score;
                    alnsymb[len++] = alnseq1[len] == alnseq2[len] ? 124 : ((score = (double)AFPAlignmentDisplay.aaScore(alnseq1[len], alnseq2[len])) > 1.0 ? 58 : 46);
                } else {
                    String tmpS = String.format("%d", i + 1);
                    alnsymb[len++] = tmpS.charAt(0);
                }
                p1b = p1;
                p2b = p2;
            }
        }
        int alnLength = len;
        afpChain.setOptAln(optAln);
        afpChain.setOptLen(optLen);
        afpChain.setAlnbeg1(alnbeg1);
        afpChain.setAlnbeg2(alnbeg2);
        afpChain.setAlnLength(alnLength);
        afpChain.setGapLen(alnLength - optLength);
    }

    private static char getOneLetter(Group g) {
        return StructureTools.get1LetterCode(g.getPDBName()).charValue();
    }

    public static int aaScore(char a, char b) {
        if (a == 'x') {
            a = (char)45;
        }
        if (b == 'x') {
            b = (char)45;
        }
        if (a == 'X') {
            a = (char)45;
        }
        if (b == 'X') {
            b = (char)45;
        }
        int pos1 = aa1List.indexOf(Character.valueOf(a));
        int pos2 = aa1List.indexOf(Character.valueOf(b));
        if (pos1 < 0) {
            logger.warn("unknown char " + a);
            return 0;
        }
        if (pos2 < 0) {
            logger.warn("unknown char " + b);
            return 0;
        }
        return aaMatrix[pos1][pos2];
    }

    public static Map<String, Double> calcIdSimilarity(char[] seq1, char[] seq2, int alnLength) {
        double identity = 0.0;
        double similarity = 0.0;
        if (seq1 == null || seq2 == null) {
            logger.warn("Can't calc %ID for an empty alignment! ");
            HashMap<String, Double> m = new HashMap<String, Double>();
            m.put("similarity", similarity);
            m.put("identity", identity);
            return m;
        }
        int eqr = 0;
        int count = 0;
        for (int i = 0; i < alnLength; ++i) {
            if (seq1[i] == '-' || seq1[i] == '*' || seq1[i] == '.' || seq2[i] == '-' || seq2[i] == '*' || seq2[i] == '.') continue;
            ++eqr;
            if (seq1[i] == seq2[i]) {
                identity += 1.0;
                similarity += 1.0;
                ++count;
                continue;
            }
            if (AFPAlignmentDisplay.aaScore(seq1[i], seq2[i]) <= 0) continue;
            similarity += 1.0;
            ++count;
        }
        if (alnLength > 0) {
            similarity /= (double)eqr;
            identity /= (double)eqr;
        }
        HashMap<String, Double> m = new HashMap<String, Double>();
        m.put("similarity", similarity);
        m.put("identity", identity);
        return m;
    }

    public static Structure createArtificalStructure(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (afpChain.getNrEQR() < 1) {
            return GuiWrapper.getAlignedStructure(ca1, ca2);
        }
        Group[] twistedGroups = GuiWrapper.prepareGroupsForDisplay(afpChain, ca1, ca2);
        ArrayList<Atom> twistedAs = new ArrayList<Atom>();
        for (Group g : twistedGroups) {
            if (g == null || g.size() < 1) continue;
            Atom a = g.getAtom(0);
            twistedAs.add(a);
        }
        Atom[] twistedAtoms = twistedAs.toArray(new Atom[twistedAs.size()]);
        ArrayList<Group> hetatms = new ArrayList();
        ArrayList<Group> nucs1 = new ArrayList();
        Group g1 = ca1[0].getGroup();
        Chain c1 = null;
        if (g1 != null && (c1 = g1.getChain()) != null) {
            hetatms = c1.getAtomGroups(GroupType.HETATM);
            nucs1 = c1.getAtomGroups(GroupType.NUCLEOTIDE);
        }
        List<Group> hetatms2 = new ArrayList<Group>();
        List<Group> nucs2 = new ArrayList<Group>();
        Group g2 = ca2[0].getGroup();
        Chain c2 = null;
        if (g2 != null && (c2 = g2.getChain()) != null) {
            hetatms2 = c2.getAtomGroups(GroupType.HETATM);
            nucs2 = c2.getAtomGroups(GroupType.NUCLEOTIDE);
        }
        Atom[] arr1 = GuiWrapper.getAtomArray(ca1, hetatms, nucs1);
        Atom[] arr2 = GuiWrapper.getAtomArray(twistedAtoms, hetatms2, nucs2);
        return GuiWrapper.getAlignedStructure(arr1, arr2);
    }

    public static int getBlockNrForAlignPos(AFPChain afpChain, int aligPos) {
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        int len = 0;
        int p1b = 0;
        int p2b = 0;
        for (int i = 0; i < blockNum; ++i) {
            for (int j = 0; j < optLen[i]; ++j) {
                int p1 = optAln[i][0][j];
                int p2 = optAln[i][1][j];
                if (len != 0) {
                    int lmax = p1 - p1b - 1 > p2 - p2b - 1 ? p1 - p1b - 1 : p2 - p2b - 1;
                    for (int k = 0; k < lmax; ++k) {
                        ++len;
                    }
                }
                p1b = p1;
                p2b = p2;
                if (len >= aligPos) {
                    return i;
                }
                ++len;
            }
        }
        return blockNum;
    }
}

