/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.lang.reflect.Array;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFPChainScorer {
    private static final Logger logger = LoggerFactory.getLogger(AFPChainScorer.class);

    public static double getTMScore(AFPChain align, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (align.getNrEQR() == 0) {
            return -1.0;
        }
        Atom[] ca1aligned = new Atom[align.getOptLength()];
        Atom[] ca2aligned = new Atom[align.getOptLength()];
        int pos = 0;
        int[] blockLens = align.getOptLen();
        int[][][] optAln = align.getOptAln();
        assert (align.getBlockNum() <= optAln.length);
        for (int block = 0; block < align.getBlockNum(); ++block) {
            if (blockLens[block] > optAln[block][0].length) {
                logger.warn("AFPChainScorer getTMScore: errors reconstructing alignment block [" + block + "]. Length is " + blockLens[block] + " but should be <=" + optAln[block][0].length);
            }
            for (int i = 0; i < blockLens[block]; ++i) {
                int pos1 = optAln[block][0][i];
                int pos2 = optAln[block][1][i];
                Atom a1 = ca1[pos1];
                Atom a2 = (Atom)ca2[pos2].clone();
                ca1aligned[pos] = a1;
                ca2aligned[pos] = a2;
                ++pos;
            }
        }
        if (pos != align.getOptLength()) {
            logger.warn("AFPChainScorer getTMScore: Problems reconstructing alignment! nr of loaded atoms is " + pos + " but should be " + align.getOptLength());
            ca1aligned = (Atom[])AFPChainScorer.resizeArray(ca1aligned, pos);
            ca2aligned = (Atom[])AFPChainScorer.resizeArray(ca2aligned, pos);
        }
        Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(ca1aligned), Calc.atomsToPoints(ca2aligned));
        Calc.transform(ca2aligned, trans);
        return Calc.getTMScore(ca1aligned, ca2aligned, ca1.length, ca2.length);
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }
}

