/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.basepairs;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.basepairs.BasePairParameters;
import org.biojava.nbio.structure.contact.Pair;

public class MismatchedBasePairParameters
extends BasePairParameters {
    public static final double DEFAULT_MAX_STAGGER = 2.0;
    public static final double DEFAULT_MAX_PROPELLER = 60.0;
    public static final double DEFAULT_MAX_SHEAR = 5.0;
    public static final double DEFAULT_MAX_STRETCH = 5.0;
    private double maxStagger = 2.0;
    private double maxShear = 5.0;
    private double maxStretch = 5.0;
    private double maxPropeller = 60.0;

    public MismatchedBasePairParameters(Structure structure, boolean RNA, boolean removeDups, boolean canonical) {
        super(structure, RNA, removeDups, canonical);
    }

    @Override
    public List<Pair<Group>> findPairs(List<Chain> chains) {
        ArrayList<Pair<Group>> result = new ArrayList<Pair<Group>>();
        boolean lastFoundPair = false;
        for (int i = 0; i < chains.size(); ++i) {
            Chain c = chains.get(i);
            String sequence = c.getAtomSequence();
            for (int m = 0; m < sequence.length(); ++m) {
                boolean foundPair = false;
                for (int j = i + 1; j < chains.size() && !foundPair; ++j) {
                    Chain c2 = chains.get(j);
                    if (j > i + 1 && c.getAtomSequence().equals(c2.getAtomSequence()) && this.nonredundant) continue;
                    String sequence2 = c2.getAtomSequence();
                    for (int k = c2.getAtomSequence().length() - 1; k >= 0 && !foundPair; --k) {
                        if (this.canonical && !BasePairParameters.match(sequence.charAt(m), sequence2.charAt(k), this.useRNA)) continue;
                        Group g1 = c.getAtomGroup(m);
                        Group g2 = c2.getAtomGroup(k);
                        Integer type1 = (Integer)BASE_MAP.get(g1.getPDBName());
                        Integer type2 = (Integer)BASE_MAP.get(g2.getPDBName());
                        if (type1 == null || type2 == null) continue;
                        Atom a1 = g1.getAtom("C1'");
                        Atom a2 = g2.getAtom("C1'");
                        if (a1 == null || a2 == null || Math.abs(a1.getCoordsAsPoint3d().distance(a2.getCoordsAsPoint3d()) - 10.0) > 4.0) continue;
                        Pair<Group> ga = new Pair<Group>(g1, g2);
                        Matrix4d data = this.basePairReferenceFrame(ga);
                        if (Math.abs(this.pairParameters[5]) > this.maxStagger || Math.abs(this.pairParameters[3]) > this.maxShear || Math.abs(this.pairParameters[4]) > this.maxStretch || Math.abs(this.pairParameters[1]) > this.maxPropeller) continue;
                        result.add(ga);
                        this.pairingNames.add(this.useRNA ? BASE_LIST_RNA[type1] + BASE_LIST_RNA[type2] : BASE_LIST_DNA[type1] + BASE_LIST_DNA[type2]);
                        foundPair = true;
                    }
                    if (!foundPair && lastFoundPair && this.pairSequence.length() > 0 && this.pairSequence.charAt(this.pairSequence.length() - 1) != ' ') {
                        this.pairSequence = this.pairSequence + ' ';
                    }
                    if (foundPair) {
                        this.pairSequence = this.pairSequence + c.getAtomSequence().charAt(i);
                    }
                    lastFoundPair = foundPair;
                }
            }
        }
        return result;
    }

    public double getMaxStagger() {
        return this.maxStagger;
    }

    public void setMaxStagger(double maxStagger) {
        this.maxStagger = maxStagger;
    }

    public double getMaxShear() {
        return this.maxShear;
    }

    public void setMaxShear(double maxShear) {
        this.maxShear = maxShear;
    }

    public double getMaxStretch() {
        return this.maxStretch;
    }

    public void setMaxStretch(double maxStretch) {
        this.maxStretch = maxStretch;
    }

    public double getMaxPropeller() {
        return this.maxPropeller;
    }

    public void setMaxPropeller(double maxPropeller) {
        this.maxPropeller = maxPropeller;
    }
}

