/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.multiple.util.ReferenceSuperimposer;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymm;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubunitCluster {
    private static final Logger logger = LoggerFactory.getLogger(SubunitCluster.class);
    private List<Subunit> subunits = new ArrayList<Subunit>();
    private List<List<Integer>> subunitEQR = new ArrayList<List<Integer>>();
    private int representative = -1;
    private SubunitClustererMethod method = SubunitClustererMethod.IDENTITY;

    public SubunitCluster(Subunit subunit) {
        this.subunits.add(subunit);
        ArrayList<Integer> identity = new ArrayList<Integer>();
        for (int i = 0; i < subunit.size(); ++i) {
            identity.add(i);
        }
        this.subunitEQR.add(identity);
        this.representative = 0;
    }

    public List<Subunit> getSubunits() {
        return Collections.unmodifiableList(this.subunits);
    }

    public boolean isIdenticalTo(SubunitCluster other) {
        String thisSequence = this.subunits.get(this.representative).getProteinSequenceString();
        String otherSequence = other.subunits.get(other.representative).getProteinSequenceString();
        return thisSequence.equals(otherSequence);
    }

    public boolean mergeIdentical(SubunitCluster other) {
        if (!this.isIdenticalTo(other)) {
            return false;
        }
        logger.info("SubunitClusters are identical");
        this.subunits.addAll(other.subunits);
        this.subunitEQR.addAll(other.subunitEQR);
        return true;
    }

    public boolean mergeIdentity95(SubunitCluster other) throws CompoundNotFoundException {
        boolean merged = this.mergeSequence(other, 0.95, 0.95, Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)new SimpleGapPenalty(), (SubstitutionMatrix<AminoAcidCompound>)SubstitutionMatrixHelper.getBlosum62());
        if (merged) {
            this.method = SubunitClustererMethod.IDENTITY;
        }
        return merged;
    }

    public boolean mergeSequence(SubunitCluster other, double minSeqid, double minCoverage) throws CompoundNotFoundException {
        return this.mergeSequence(other, minSeqid, minCoverage, Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)new SimpleGapPenalty(), (SubstitutionMatrix<AminoAcidCompound>)SubstitutionMatrixHelper.getBlosum62());
    }

    public boolean mergeSequence(SubunitCluster other, double minSeqid, double minCoverage, Alignments.PairwiseSequenceAlignerType alignerType, GapPenalty gapPenalty, SubstitutionMatrix<AminoAcidCompound> subsMatrix) throws CompoundNotFoundException {
        int column;
        int t;
        double lengthOther;
        double lengthThis;
        ProteinSequence thisSequence = this.subunits.get(this.representative).getProteinSequence();
        ProteinSequence otherSequence = other.subunits.get(other.representative).getProteinSequence();
        PairwiseSequenceAligner aligner = Alignments.getPairwiseAligner((Sequence)thisSequence, (Sequence)otherSequence, (Alignments.PairwiseSequenceAlignerType)alignerType, (GapPenalty)gapPenalty, subsMatrix);
        double gaps1 = aligner.getPair().getAlignedSequence(1).getNumGapPositions();
        double gaps2 = aligner.getPair().getAlignedSequence(2).getNumGapPositions();
        double lengthAlignment = aligner.getPair().getLength();
        double coverage = (lengthAlignment - gaps1 - gaps2) / Math.max(lengthThis = (double)((ProteinSequence)aligner.getQuery()).getLength(), lengthOther = (double)((ProteinSequence)aligner.getTarget()).getLength());
        if (coverage < minCoverage) {
            return false;
        }
        double seqid = aligner.getPair().getPercentageOfIdentity();
        if (seqid < minSeqid) {
            return false;
        }
        logger.info(String.format("SubunitClusters are similar in sequence with %.2f sequence identity and %.2f coverage", seqid, coverage));
        ArrayList<Integer> thisAligned = new ArrayList<Integer>();
        ArrayList<Integer> otherAligned = new ArrayList<Integer>();
        for (int p = 1; p < aligner.getPair().getLength() + 1; ++p) {
            if (aligner.getPair().getAlignedSequence(1).isGap(p) || aligner.getPair().getAlignedSequence(2).isGap(p)) continue;
            int thisIndex = aligner.getPair().getIndexInQueryAt(p) - 1;
            int otherIndex = aligner.getPair().getIndexInTargetAt(p) - 1;
            if (!this.subunitEQR.get(this.representative).contains(thisIndex) || !other.subunitEQR.get(other.representative).contains(otherIndex)) continue;
            thisAligned.add(thisIndex);
            otherAligned.add(otherIndex);
        }
        ArrayList<Integer> thisRemove = new ArrayList<Integer>();
        ArrayList<Integer> otherRemove = new ArrayList<Integer>();
        for (t = 0; t < this.subunitEQR.get(this.representative).size(); ++t) {
            if (thisAligned.contains(this.subunitEQR.get(this.representative).get(t))) continue;
            thisRemove.add(t);
        }
        for (t = 0; t < other.subunitEQR.get(other.representative).size(); ++t) {
            if (otherAligned.contains(other.subunitEQR.get(other.representative).get(t))) continue;
            otherRemove.add(t);
        }
        Collections.sort(thisRemove);
        Collections.reverse(thisRemove);
        Collections.sort(otherRemove);
        Collections.reverse(otherRemove);
        for (t = 0; t < thisRemove.size(); ++t) {
            for (List<Integer> eqr : this.subunitEQR) {
                column = (Integer)thisRemove.get(t);
                eqr.remove(column);
            }
        }
        for (t = 0; t < otherRemove.size(); ++t) {
            for (List<Integer> eqr : other.subunitEQR) {
                column = (Integer)otherRemove.get(t);
                eqr.remove(column);
            }
        }
        if (this.subunits.get(this.representative).size() < other.subunits.get(other.representative).size()) {
            this.representative = other.representative + this.subunits.size();
        }
        this.subunits.addAll(other.subunits);
        this.subunitEQR.addAll(other.subunitEQR);
        this.method = SubunitClustererMethod.SEQUENCE;
        return true;
    }

    public boolean mergeStructure(SubunitCluster other, double maxRmsd, double minCoverage) throws StructureException {
        StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm("jCE");
        return this.mergeStructure(other, maxRmsd, minCoverage, algorithm);
    }

    public boolean mergeStructure(SubunitCluster other, double maxRmsd, double minCoverage, StructureAlignment aligner) throws StructureException {
        int column;
        int t;
        AFPChain afp = aligner.align(this.subunits.get(this.representative).getRepresentativeAtoms(), other.subunits.get(other.representative).getRepresentativeAtoms());
        MultipleAlignment msa = new MultipleAlignmentEnsembleImpl(afp, this.subunits.get(this.representative).getRepresentativeAtoms(), other.subunits.get(other.representative).getRepresentativeAtoms(), false).getMultipleAlignment(0);
        double coverage = Math.min(msa.getCoverages().get(0), msa.getCoverages().get(1));
        if (coverage < minCoverage) {
            return false;
        }
        double rmsd = afp.getTotalRmsdOpt();
        if (rmsd > maxRmsd) {
            return false;
        }
        String.format("SubunitClusters are structurally similar with %.2f RMSD %.2f coverage", rmsd, coverage);
        List<List<Integer>> alignedRes = msa.getBlock(0).getAlignRes();
        ArrayList<Integer> thisAligned = new ArrayList<Integer>();
        ArrayList<Integer> otherAligned = new ArrayList<Integer>();
        for (int p = 0; p < msa.length(); ++p) {
            if (alignedRes.get(0).get(p) == null || alignedRes.get(1).get(p) == null) continue;
            int thisIndex = alignedRes.get(0).get(p);
            int otherIndex = alignedRes.get(1).get(p);
            if (!this.subunitEQR.get(this.representative).contains(thisIndex) || !other.subunitEQR.get(other.representative).contains(otherIndex)) continue;
            thisAligned.add(thisIndex);
            otherAligned.add(otherIndex);
        }
        ArrayList<Integer> thisRemove = new ArrayList<Integer>();
        ArrayList<Integer> otherRemove = new ArrayList<Integer>();
        for (t = 0; t < this.subunitEQR.get(this.representative).size(); ++t) {
            if (thisAligned.contains(this.subunitEQR.get(this.representative).get(t))) continue;
            thisRemove.add(t);
        }
        for (t = 0; t < other.subunitEQR.get(other.representative).size(); ++t) {
            if (otherAligned.contains(other.subunitEQR.get(other.representative).get(t))) continue;
            otherRemove.add(t);
        }
        Collections.sort(thisRemove);
        Collections.reverse(thisRemove);
        Collections.sort(otherRemove);
        Collections.reverse(otherRemove);
        for (t = 0; t < thisRemove.size(); ++t) {
            for (List<Integer> eqr : this.subunitEQR) {
                column = (Integer)thisRemove.get(t);
                eqr.remove(column);
            }
        }
        for (t = 0; t < otherRemove.size(); ++t) {
            for (List<Integer> eqr : other.subunitEQR) {
                column = (Integer)otherRemove.get(t);
                eqr.remove(column);
            }
        }
        if (this.subunits.get(this.representative).size() < other.subunits.get(other.representative).size()) {
            this.representative = other.representative + this.subunits.size();
        }
        this.subunits.addAll(other.subunits);
        this.subunitEQR.addAll(other.subunitEQR);
        this.method = SubunitClustererMethod.STRUCTURE;
        return true;
    }

    public boolean divideInternally(double coverageThreshold, double rmsdThreshold, int minSequenceLength) throws StructureException {
        int s;
        CESymmParameters params = new CESymmParameters();
        params.setMinCoreLength(minSequenceLength);
        params.setGaps(false);
        CeSymmResult result = CeSymm.analyze(this.subunits.get(this.representative).getRepresentativeAtoms(), params);
        if (!result.isSignificant()) {
            return false;
        }
        double rmsd = result.getMultipleAlignment().getScore("RMSD");
        if (rmsd > rmsdThreshold) {
            return false;
        }
        double coverage = result.getMultipleAlignment().getCoverages().get(0) * (double)result.getNumRepeats();
        if (coverage < coverageThreshold) {
            return false;
        }
        logger.info("SubunitCluster is internally symmetric with {} repeats, {} RMSD and {} coverage", new Object[]{result.getNumRepeats(), rmsd, coverage});
        List<List<Integer>> alignedRes = result.getMultipleAlignment().getBlock(0).getAlignRes();
        ArrayList columns = new ArrayList();
        for (int s2 = 0; s2 < alignedRes.size(); ++s2) {
            columns.add(new ArrayList(alignedRes.get(s2).size()));
        }
        for (int col = 0; col < alignedRes.get(0).size(); ++col) {
            boolean missing = false;
            for (s = 0; s < alignedRes.size(); ++s) {
                if (this.subunitEQR.get(this.representative).contains(alignedRes.get(s).get(col))) continue;
                missing = true;
                break;
            }
            if (missing) continue;
            for (s = 0; s < alignedRes.size(); ++s) {
                ((List)columns.get(s)).add(this.subunitEQR.get(this.representative).indexOf(alignedRes.get(s).get(col)));
            }
        }
        ArrayList<Subunit> newSubunits = new ArrayList<Subunit>(this.subunits.size() * columns.size());
        ArrayList<List<Integer>> newSubunitEQR = new ArrayList<List<Integer>>(this.subunits.size() * columns.size());
        for (s = 0; s < this.subunits.size(); ++s) {
            for (int r = 0; r < columns.size(); ++r) {
                int start = this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(0));
                int end = this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(((List)columns.get(r)).size() - 1));
                Atom[] reprAtoms = Arrays.copyOfRange(this.subunits.get(s).getRepresentativeAtoms(), start, end + 1);
                newSubunits.add(new Subunit(reprAtoms, this.subunits.get(s).getName(), this.subunits.get(s).getIdentifier(), this.subunits.get(s).getStructure()));
                ArrayList<Integer> eqr = new ArrayList<Integer>();
                for (int p = 0; p < ((List)columns.get(r)).size(); ++p) {
                    eqr.add(this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(p)) - start);
                }
                newSubunitEQR.add(eqr);
            }
        }
        this.subunits = newSubunits;
        this.subunitEQR = newSubunitEQR;
        for (s = 0; s < this.subunits.size(); ++s) {
            if (this.subunits.get(s).size() <= this.subunits.get(this.representative).size()) continue;
            this.representative = s;
        }
        this.method = SubunitClustererMethod.STRUCTURE;
        return true;
    }

    public int size() {
        return this.subunits.size();
    }

    public int length() {
        return this.subunitEQR.get(this.representative).size();
    }

    public SubunitClustererMethod getClustererMethod() {
        return this.method;
    }

    public List<Atom[]> getAlignedAtomsSubunits() {
        List<Atom[]> alignedAtoms = Collections.emptyList();
        for (int s = 0; s < this.subunits.size(); ++s) {
            alignedAtoms.add(this.getAlignedAtomsSubunit(s));
        }
        return alignedAtoms;
    }

    public Atom[] getAlignedAtomsSubunit(int index) {
        Atom[] aligned = new Atom[this.subunitEQR.get(index).size()];
        for (int p = 0; p < this.subunitEQR.get(index).size(); ++p) {
            aligned[p] = this.subunits.get(index).getRepresentativeAtoms()[this.subunitEQR.get(index).get(p)];
        }
        return aligned;
    }

    public MultipleAlignment getMultipleAlignment() throws StructureException {
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl();
        msa.setEnsemble(new MultipleAlignmentEnsembleImpl());
        msa.getEnsemble().setAtomArrays(this.subunits.stream().map(s -> s.getRepresentativeAtoms()).collect(Collectors.toList()));
        BlockSetImpl bs = new BlockSetImpl(msa);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(this.subunitEQR);
        new ReferenceSuperimposer(this.representative).superimpose(msa);
        MultipleAlignmentScorer.calculateScores(msa);
        return msa;
    }

    public String toString() {
        return "SubunitCluster [Size=" + this.size() + ", Length=" + this.length() + ", Representative=" + this.representative + ", Method=" + (Object)((Object)this.method) + "]";
    }
}

