/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;

public class SubunitClusterUtils {
    private SubunitClusterUtils() {
    }

    public static String getStoichiometryString(List<SubunitCluster> clusters) {
        List stoichiometries = clusters.stream().map(c -> c.size()).collect(Collectors.toList());
        Collections.sort(stoichiometries);
        Collections.reverse(stoichiometries);
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        StringBuilder formula = new StringBuilder();
        for (int i = 0; i < stoichiometries.size(); ++i) {
            String key = "?";
            if (i < alpha.length()) {
                key = alpha.substring(i, i + 1);
            }
            formula.append(key);
            if ((Integer)stoichiometries.get(i) <= 1) continue;
            formula.append(stoichiometries.get(i));
        }
        return formula.toString();
    }

    public static boolean isPseudoStoichiometric(List<SubunitCluster> clusters) {
        for (SubunitCluster c : clusters) {
            if (c.getClustererMethod() != SubunitClustererMethod.STRUCTURE && c.getClustererMethod() != SubunitClustererMethod.SEQUENCE) continue;
            return true;
        }
        return false;
    }
}

