/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.cluster.SubunitClusterer;
import org.biojava.nbio.structure.cluster.SubunitClustererParameters;
import org.biojava.nbio.structure.symmetry.core.C2RotationSolver;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.HelixSolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.RotationSolver;
import org.biojava.nbio.structure.symmetry.core.SymmetryPerceptionMethod;
import org.biojava.nbio.structure.symmetry.utils.PowerSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuatSymmetryDetector {
    private static final Logger logger = LoggerFactory.getLogger(QuatSymmetryDetector.class);

    private QuatSymmetryDetector() {
    }

    public static QuatSymmetryResults calcGlobalSymmetry(Structure structure, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        List<SubunitCluster> clusters = SubunitClusterer.cluster(structure, clusterParams);
        return QuatSymmetryDetector.calcGlobalSymmetry(clusters, symmParams);
    }

    public static QuatSymmetryResults calcGlobalSymmetry(List<Subunit> subunits, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        List<SubunitCluster> clusters = SubunitClusterer.cluster(subunits, clusterParams);
        return QuatSymmetryDetector.calcGlobalSymmetry(clusters, symmParams);
    }

    public static QuatSymmetryResults calcGlobalSymmetry(List<SubunitCluster> clusters, QuatSymmetryParameters symmParams) {
        return QuatSymmetryDetector.calcQuatSymmetry(clusters, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(Structure structure, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        List<SubunitCluster> clusters = SubunitClusterer.cluster(structure, clusterParams);
        return QuatSymmetryDetector.calcLocalSymmetries(clusters, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(List<Subunit> subunits, QuatSymmetryParameters symmParams, SubunitClustererParameters clusterParams) {
        List<SubunitCluster> clusters = SubunitClusterer.cluster(subunits, clusterParams);
        return QuatSymmetryDetector.calcLocalSymmetries(clusters, symmParams);
    }

    public static List<QuatSymmetryResults> calcLocalSymmetries(List<SubunitCluster> clusters, QuatSymmetryParameters symmParams) {
        ArrayList<QuatSymmetryResults> localSymmetries = new ArrayList<QuatSymmetryResults>();
        if (clusters.size() < 2) {
            return localSymmetries;
        }
        QuatSymmetrySubunits subunits = new QuatSymmetrySubunits(clusters);
        if (subunits.getSubunitCount() < 3 || subunits.getSubunitCount() > symmParams.getMaximumLocalSubunits()) {
            return localSymmetries;
        }
        long start = System.nanoTime();
        Set<Set<SubunitCluster>> powerSet = new PowerSet<SubunitCluster>().powerSet(new HashSet<SubunitCluster>(clusters));
        int combinations = 1;
        for (Set<SubunitCluster> cluster : powerSet) {
            double time = (System.nanoTime() - start) / 1000000000L;
            if (time > symmParams.getLocalTimeLimit()) {
                logger.warn("Exceeded time limit for local symmetry calculations. {} seconds elapsed. Local symmetry results may be incomplete.", (Object)time);
                break;
            }
            if (localSymmetries.size() > symmParams.getMaximumLocalResults()) {
                logger.warn("Exceeded maximum number of local symmetry results. {} results calculated. Local symmetry results may be incomplete.", (Object)localSymmetries.size());
                break;
            }
            if (combinations > symmParams.getMaximumLocalCombinations()) {
                logger.warn("Exceeded maximum number of local combinations. {} combinations tried. Local symmetry results may be incomplete.", (Object)combinations);
                break;
            }
            if (cluster.size() == 0 || cluster.size() == clusters.size()) continue;
            ArrayList<SubunitCluster> localClusters = new ArrayList<SubunitCluster>(cluster);
            QuatSymmetryResults localResult = QuatSymmetryDetector.calcGlobalSymmetry(localClusters, symmParams);
            if (!localResult.getSymmetry().equals("C1")) {
                localResult.setLocal(true);
                localSymmetries.add(localResult);
            }
            ++combinations;
        }
        return localSymmetries;
    }

    private static QuatSymmetryResults calcQuatSymmetry(List<SubunitCluster> clusters, QuatSymmetryParameters parameters) {
        HelixSolver hc;
        HelixLayers helixLayers;
        QuatSymmetrySolver solver;
        QuatSymmetrySubunits subunits = new QuatSymmetrySubunits(clusters);
        if (subunits.getSubunitCount() == 0) {
            return null;
        }
        RotationGroup rotationGroup = null;
        SymmetryPerceptionMethod method = null;
        if (subunits.getFolds().size() == 1) {
            method = SymmetryPerceptionMethod.NO_ROTATION;
            rotationGroup = new RotationGroup();
            rotationGroup.setC1(subunits.getSubunitCount());
        } else if (subunits.getSubunitCount() == 2 && subunits.getFolds().contains(2)) {
            method = SymmetryPerceptionMethod.C2_ROTATION;
            solver = new C2RotationSolver(subunits, parameters);
            rotationGroup = solver.getSymmetryOperations();
        } else {
            method = SymmetryPerceptionMethod.ROTATION;
            solver = new RotationSolver(subunits, parameters);
            rotationGroup = solver.getSymmetryOperations();
        }
        QuatSymmetryResults results = new QuatSymmetryResults(clusters, rotationGroup, method);
        String symmetry = results.getSymmetry();
        if (symmetry.startsWith("C") && (helixLayers = (hc = new HelixSolver(subunits, rotationGroup.getOrder(), parameters)).getSymmetryOperations()).size() > 0) {
            double cRmsd = rotationGroup.getScores().getRmsd();
            double hRmsd = helixLayers.getScores().getRmsd();
            double deltaRmsd = hRmsd - cRmsd;
            if (symmetry.equals("C1") || !symmetry.equals("C1") && deltaRmsd <= parameters.getHelixRmsdThreshold()) {
                method = SymmetryPerceptionMethod.ROTO_TRANSLATION;
                results = new QuatSymmetryResults(clusters, helixLayers, method);
            }
        }
        return results;
    }
}

