/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.cluster.SubunitClusterUtils;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.SymmetryPerceptionMethod;

public class QuatSymmetryResults {
    private Structure structure;
    private List<SubunitCluster> clusters;
    private boolean local = false;
    private String stoichiometry;
    private List<Subunit> subunits;
    private SymmetryPerceptionMethod method;
    private RotationGroup rotationGroup;
    private HelixLayers helixLayers;

    public QuatSymmetryResults(List<SubunitCluster> clusters, RotationGroup rotationGroup, SymmetryPerceptionMethod method) {
        this.clusters = clusters;
        this.stoichiometry = SubunitClusterUtils.getStoichiometryString(clusters);
        this.subunits = new ArrayList<Subunit>();
        for (SubunitCluster c : clusters) {
            this.subunits.addAll(c.getSubunits());
        }
        this.rotationGroup = rotationGroup;
        this.method = method;
    }

    public QuatSymmetryResults(List<SubunitCluster> clusters, HelixLayers helixLayers, SymmetryPerceptionMethod method) {
        this.clusters = clusters;
        this.stoichiometry = SubunitClusterUtils.getStoichiometryString(clusters);
        this.subunits = new ArrayList<Subunit>();
        for (SubunitCluster c : clusters) {
            this.subunits.addAll(c.getSubunits());
        }
        this.helixLayers = helixLayers;
        this.method = method;
    }

    public List<SubunitCluster> getSubunitClusters() {
        return Collections.unmodifiableList(this.clusters);
    }

    public List<Subunit> getSubunits() {
        return Collections.unmodifiableList(this.subunits);
    }

    public int getSubunitCount() {
        return this.subunits.size();
    }

    public RotationGroup getRotationGroup() {
        return this.rotationGroup;
    }

    public HelixLayers getHelixLayers() {
        return this.helixLayers;
    }

    public SymmetryPerceptionMethod getMethod() {
        return this.method;
    }

    public String getSymmetry() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return "H";
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getPointGroup();
        }
        return "";
    }

    public QuatSymmetryScores getScores() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return this.helixLayers.getScores();
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getScores();
        }
        return new QuatSymmetryScores();
    }

    public String getStoichiometry() {
        return this.stoichiometry;
    }

    public boolean isPseudoStoichiometric() {
        return SubunitClusterUtils.isPseudoStoichiometric(this.clusters);
    }

    public boolean isLocal() {
        return this.local;
    }

    void setLocal(boolean local) {
        this.local = local;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public String toString() {
        return "QuatSymmetryResults [stoichiometry: " + this.getStoichiometry() + ", symmetry: " + this.getSymmetry() + ", pseudo-stoichiometric: " + this.isPseudoStoichiometric() + ", local: " + this.local + ", method: " + (Object)((Object)this.method) + "]";
    }
}

