/*
 * Decompiled with CFR 0.152.
 */
package org.codeability.sharing.plugins.api.search;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codeability.sharing.plugins.api.jsonSupport.NoUTCInstantDeserializer;
import org.codeability.sharing.plugins.api.jsonSupport.UTCInstantSerializer;
import org.codeability.sharing.plugins.api.search.GitProjectDTO;
import org.codeability.sharing.plugins.api.search.SearchStatisticsDTO;
import org.codeability.sharing.plugins.api.search.UserProvidedMetadataDTO;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class SearchResultDTO {
    private GitProjectDTO project;
    private MetadataFile file;
    private UserProvidedMetadataDTO metadata;
    private SearchStatisticsDTO searchStatistics;
    private String exerciseId;
    private int ranking5;
    private List<PluginActionInfo> supportedActions = new ArrayList<PluginActionInfo>(2);

    public GitProjectDTO getProject() {
        return this.project;
    }

    public SearchResultDTO() {
    }

    public SearchResultDTO(SearchResultDTO toClone) {
        this.project = toClone.project;
        this.file = toClone.file;
        this.metadata = toClone.metadata;
    }

    public void setProject(GitProjectDTO project) {
        this.project = project;
    }

    public String getExerciseId() {
        return this.exerciseId;
    }

    public MetadataFile getFile() {
        return this.file;
    }

    public void setFile(MetadataFile file) {
        this.file = file;
    }

    public UserProvidedMetadataDTO getMetadata() {
        return this.metadata;
    }

    public void setMetadata(UserProvidedMetadataDTO metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return "SearchResultDTO : { project: " + this.project + ", file: " + this.file + ", metadata: " + this.metadata + " }";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exerciseId == null ? 0 : this.exerciseId.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.getSearchStatistics() == null ? 0 : this.getSearchStatistics().hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResultDTO)) {
            return false;
        }
        SearchResultDTO other = (SearchResultDTO)obj;
        if (this.exerciseId == null ? other.exerciseId != null : !this.exerciseId.equals(other.exerciseId)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        return !(this.getSearchStatistics() == null ? other.getSearchStatistics() != null : !this.getSearchStatistics().equals(other.getSearchStatistics()));
    }

    public void setExerciseId(String exerciseId) {
        this.exerciseId = exerciseId;
    }

    public int getRanking5() {
        return this.ranking5;
    }

    public void setRanking5(int ranking5) {
        this.ranking5 = ranking5;
    }

    public List<PluginActionInfo> getSupportedActions() {
        return this.supportedActions;
    }

    public void setSupportedActions(List<PluginActionInfo> supportedActions) {
        this.supportedActions = supportedActions;
    }

    public SearchStatisticsDTO getSearchStatistics() {
        return this.searchStatistics;
    }

    public void setSearchStatistics(SearchStatisticsDTO searchStatistics) {
        this.searchStatistics = searchStatistics;
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public static class MetadataFile {
        private String filename;
        private String path;
        private String commit_id;
        private String parentId;
        private String[] children;
        @JsonDeserialize(converter=NoUTCInstantDeserializer.class)
        @JsonSerialize(converter=UTCInstantSerializer.class)
        private Instant indexing_date;
        @JsonDeserialize(converter=NoUTCInstantDeserializer.class)
        @JsonSerialize(converter=UTCInstantSerializer.class)
        private Instant last_activity_at;

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getCommit_id() {
            return this.commit_id;
        }

        public void setCommit_id(String commit_id) {
            this.commit_id = commit_id;
        }

        public Instant getIndexing_date() {
            return this.indexing_date;
        }

        public void setIndexing_date(Instant indexing_date) {
            this.indexing_date = indexing_date;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String[] getChildren() {
            return this.children;
        }

        public void setChildren(String[] children) {
            this.children = children;
        }

        public final int hashCode() {
            int prime = 31;
            int result = this.path.hashCode();
            result = 31 * result + (this.commit_id == null ? 0 : this.commit_id.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MetadataFile)) {
                return false;
            }
            MetadataFile other = (MetadataFile)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.commit_id, other.commit_id);
        }

        public String toString() {
            return "MetadataFile: { filename: " + this.filename + ", path: " + this.path + ", commit_id: " + this.commit_id + ", indexing_date: " + this.indexing_date + " }";
        }

        public Instant getLast_activity_at() {
            return this.last_activity_at;
        }

        public void setLast_activity_at(Instant last_activity_at) {
            this.last_activity_at = last_activity_at;
        }
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public static class PluginActionInfo {
        String plugin;
        String action;
        String commandName;

        public PluginActionInfo(String plugin, String action, String commandName) {
            this.plugin = plugin;
            this.action = action;
            this.commandName = commandName;
        }

        public PluginActionInfo() {
        }

        public String getPlugin() {
            return this.plugin;
        }

        public void setPlugin(String plugin) {
            this.plugin = plugin;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public void setCommandName(String commandName) {
            this.commandName = commandName;
        }
    }
}

