/*
 * Decompiled with CFR 0.152.
 */
package org.codeability.sharing.plugins.api.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

public class SecretChecksumCalculator {
    private SecretChecksumCalculator() {
    }

    public static String calculateChecksum(Map<String, String> params, String secretKey) {
        try {
            TreeMap<String, String> sortedParams = new TreeMap<String, String>();
            sortedParams.putAll(params);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(secretKey.getBytes());
            for (String str : sortedParams.values()) {
                md.update(str.getBytes());
            }
            byte[] checksumBytes = md.digest();
            StringBuilder checksumHex = new StringBuilder();
            byte[] byArray = checksumBytes;
            int n = checksumBytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                checksumHex.append(String.format("%02x", b));
                ++n2;
            }
            return checksumHex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: MD5-Algorithm not available?", e);
        }
    }

    public static boolean checkChecksum(Map<String, String> params, String secretKey, String checkSum) {
        String expected = SecretChecksumCalculator.calculateChecksum(params, secretKey);
        return checkSum != null && checkSum.equals(expected);
    }

    public static String constructParamURL(String base, Map<String, String> params, String secretKey) {
        try {
            StringBuilder parameterizedURL = new StringBuilder(base);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String encodedParamName = URLEncoder.encode(entry.getKey(), "UTF-8");
                String encodedParamValue = URLEncoder.encode(entry.getValue(), "UTF-8");
                SecretChecksumCalculator.extendParam(parameterizedURL, encodedParamName, encodedParamValue);
            }
            String checkSum = SecretChecksumCalculator.calculateChecksum(params, secretKey);
            SecretChecksumCalculator.extendParam(parameterizedURL, "checksum", checkSum);
            return parameterizedURL.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error: UTF-8 encoding not supported", e);
        }
    }

    private static void extendParam(StringBuilder parameterizedURL, String encodedParamName, String encodedParamValue) {
        if (parameterizedURL.indexOf("?") >= 0) {
            parameterizedURL.append("&");
        } else {
            parameterizedURL.append("?");
        }
        parameterizedURL.append(encodedParamName);
        parameterizedURL.append("=");
        parameterizedURL.append(encodedParamValue);
    }
}

