/*
 * Decompiled with CFR 0.152.
 */
package org.codeability.sharing.plugins.api.search.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize(using=ExerciseIdSerializer.class)
@JsonDeserialize(using=ExerciseIdDeserializer.class)
public class ExerciseId {
    private String projectId;
    private String path;
    private String gitUrl;
    protected static final Pattern ExerciseIdPattern = Pattern.compile("^(http[^\\[]+)?(\\[(\\d*)\\])?(.+)?$");
    protected static final Pattern ExerciseIdPatternOld = Pattern.compile("(\\d+)(:(.*))?");

    public ExerciseId() {
    }

    public ExerciseId(String projectId, String path) {
        this(projectId, path, null);
    }

    public ExerciseId(String projectId, String path, String gitUrl) {
        if (projectId == null && gitUrl == null) {
            throw new IllegalArgumentException("project id and gitUrl must not be both null");
        }
        if (projectId != null) {
            this.projectId = projectId.trim();
            if (!StringUtils.isNumeric((CharSequence)projectId)) {
                throw new IllegalArgumentException("project id must be numeric");
            }
        }
        this.path = StringUtils.isEmpty((CharSequence)path) ? null : path.trim();
        this.gitUrl = StringUtils.isEmpty((CharSequence)gitUrl) ? null : gitUrl.trim();
    }

    public ExerciseId getRootExerciseId() {
        return new ExerciseId(this.projectId, "", this.gitUrl);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPath() {
        return this.path;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public String extendPath(String extraPath) {
        if (this.path == null || this.path == "") {
            return extraPath;
        }
        if (extraPath == null || extraPath == "") {
            return this.path;
        }
        if (extraPath.startsWith("/")) {
            return "/" + this.path + extraPath;
        }
        return this.path + "/" + extraPath;
    }

    public String toString() {
        if (!StringUtils.isEmpty((CharSequence)this.gitUrl)) {
            if (StringUtils.isEmpty((CharSequence)this.path)) {
                return this.gitUrl;
            }
            return this.gitUrl + "[]" + this.path;
        }
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            return "[" + this.projectId + "]";
        }
        return "[" + this.projectId + "]" + this.path;
    }

    public boolean isDescendantOf(ExerciseId parent) {
        if (parent.gitUrl != null && !parent.gitUrl.equals(this.gitUrl)) {
            return false;
        }
        if (parent.gitUrl == null && this.gitUrl != null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)parent.projectId, (CharSequence)this.projectId)) {
            return false;
        }
        if (parent.path == null) {
            return true;
        }
        if (this.path == null) {
            return false;
        }
        return this.path.startsWith(parent.path);
    }

    public static ExerciseId fromString(String externalRepresentation) throws ParseException {
        Matcher ma = ExerciseIdPattern.matcher(externalRepresentation);
        if (!ma.matches()) {
            return ExerciseId.fromStringOld(externalRepresentation);
        }
        MatchResult matchResult = ma.toMatchResult();
        String gitUrl = matchResult.group(1);
        String projectId = matchResult.group(3);
        if (projectId == null) {
            return ExerciseId.fromStringOld(externalRepresentation);
        }
        if ("".equals(projectId)) {
            projectId = null;
        }
        String path = matchResult.group(4);
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return new ExerciseId(projectId, path, gitUrl);
    }

    public static ExerciseId fromStringOld(String externalRepresentation) throws ParseException {
        Matcher ma = ExerciseIdPatternOld.matcher(externalRepresentation);
        if (!ma.matches()) {
            throw new ParseException("Cannot parse " + externalRepresentation, 0);
        }
        MatchResult matchResult = ma.toMatchResult();
        String projectId = matchResult.group(1);
        String path = matchResult.group(3);
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return new ExerciseId(projectId, path);
    }

    public int hashCode() {
        return Objects.hash(this.gitUrl, this.path, this.projectId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExerciseId other = (ExerciseId)obj;
        return Objects.equals(this.gitUrl, other.gitUrl) && Objects.equals(this.path, other.path) && Objects.equals(this.projectId, other.projectId);
    }

    public static class ExerciseIdDeserializer
    extends StdDeserializer<ExerciseId> {
        private static final long serialVersionUID = 1L;

        protected ExerciseIdDeserializer() {
            super(ExerciseId.class);
        }

        public ExerciseId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String id = node.asText();
            try {
                return ExerciseId.fromString(id);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse exerciseId " + id);
            }
        }
    }

    public static class ExerciseIdSerializer
    extends StdSerializer<ExerciseId> {
        private static final long serialVersionUID = 1L;

        protected ExerciseIdSerializer() {
            super(ExerciseId.class, true);
        }

        public void serialize(ExerciseId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

