/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F0;
import fj.F2;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.data.Array;
import fj.data.Either;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Seq;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.TreeMap;
import fj.data.Validation;
import fj.data.Writer;
import fj.data.hamt.BitSet;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Equal<A> {
    private final Definition<A> def;
    public static final Equal<Boolean> booleanEqual = Equal.anyEqual();
    public static final Equal<Byte> byteEqual = Equal.anyEqual();
    public static final Equal<Character> charEqual = Equal.anyEqual();
    public static final Equal<Double> doubleEqual = Equal.anyEqual();
    public static final Equal<Float> floatEqual = Equal.anyEqual();
    public static final Equal<Integer> intEqual = Equal.anyEqual();
    public static final Equal<BigInteger> bigintEqual = Equal.anyEqual();
    public static final Equal<BigDecimal> bigdecimalEqual = Equal.anyEqual();
    public static final Equal<Long> longEqual = Equal.anyEqual();
    public static final Equal<Short> shortEqual = Equal.anyEqual();
    public static final Equal<Natural> naturalEqual = bigintEqual.contramap(Natural::bigIntegerValue);
    public static final Equal<String> stringEqual = Equal.anyEqual();
    public static final Equal<StringBuffer> stringBufferEqual = Equal.equalDef((A sb1, A sb2) -> {
        if (sb1.length() == sb2.length()) {
            for (int i = 0; i < sb1.length(); ++i) {
                if (sb1.charAt(i) == sb2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    });
    public static final Equal<StringBuilder> stringBuilderEqual = Equal.equalDef((A sb1, A sb2) -> {
        if (sb1.length() == sb2.length()) {
            for (int i = 0; i < sb1.length(); ++i) {
                if (sb1.charAt(i) == sb2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    });
    public static final Equal<BitSet> bitSetSequal = Equal.equalDef((A bs1, A bs2) -> bs1.longValue() == bs2.longValue());
    public static final Equal<LazyString> eq = Equal.streamEqual(charEqual).contramap(LazyString.toStream);
    public static final Equal<HList.HNil> hListEqual = Equal.anyEqual();

    private Equal(Definition<A> def) {
        this.def = def;
    }

    public boolean eq(A a1, A a2) {
        return this.def.equal(a1, a2);
    }

    public boolean notEq(A a1, A a2) {
        return !this.def.equal(a1, a2);
    }

    public F2<A, A, Boolean> eq() {
        return this.def::equal;
    }

    public F<A, Boolean> eq(A a) {
        return this.def.equal(a);
    }

    public <B> Equal<B> contramap(final F<B, A> f) {
        final Definition<A> eaDef = this.def;
        return Equal.equalDef(new Definition<B>(){

            @Override
            public F<B, Boolean> equal(B b) {
                return Function.compose(eaDef.equal(f.f(b)), f);
            }

            @Override
            public boolean equal(B b1, B b2) {
                return eaDef.equal(f.f(b1), f.f(b2));
            }
        });
    }

    public static <A> Equal<A> equal(F<A, F<A, Boolean>> f) {
        return new Equal<Object>(f::f);
    }

    public static <A> Equal<A> equal(F2<A, A, Boolean> f) {
        return Equal.equalDef(f::f);
    }

    public static <A> Equal<A> equalDef(Definition<A> definition) {
        return new Equal<A>(definition);
    }

    public static <A> Equal<A> equalDef(AltDefinition<A> definition) {
        return new Equal<A>(definition);
    }

    public static <A> Equal<A> anyEqual() {
        return Equal.equalDef(new Definition<A>(){

            @Override
            public F<A, Boolean> equal(A a) {
                return a::equals;
            }

            @Override
            public boolean equal(A a1, A a2) {
                return a1.equals(a2);
            }
        });
    }

    public static <A, B> Equal<Either<A, B>> eitherEqual(Equal<A> ea, Equal<B> eb) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        return Equal.equalDef((A e1) -> e1.either(a1 -> Either.either_(eaDef.equal(a1), __ -> false), b1 -> Either.either_(__ -> false, ebDef.equal(b1))));
    }

    public static <A, B> Equal<Validation<A, B>> validationEqual(Equal<A> ea, Equal<B> eb) {
        return Equal.eitherEqual(ea, eb).contramap(Validation.either());
    }

    public static <A> Equal<List<A>> listEqual(Equal<A> ea) {
        Definition eaDef = ea.def;
        return Equal.equalDef((A a1, A a2) -> {
            List x1 = a1;
            List x2 = a2;
            while (x1.isNotEmpty() && x2.isNotEmpty()) {
                if (!eaDef.equal(x1.head(), x2.head())) {
                    return false;
                }
                x1 = x1.tail();
                x2 = x2.tail();
            }
            return x1.isEmpty() && x2.isEmpty();
        });
    }

    public static <A> Equal<NonEmptyList<A>> nonEmptyListEqual(Equal<A> ea) {
        return Equal.listEqual(ea).contramap(NonEmptyList.toList_());
    }

    public static <A> Equal<Option<A>> optionEqual(Equal<A> ea) {
        Definition eaDef = ea.def;
        return Equal.equalDef((A o1) -> o1.option(Option.isNone_(), a1 -> Option.option_(false, eaDef.equal(a1))));
    }

    public static <A> Equal<Seq<A>> seqEqual(Equal<A> e) {
        return Equal.streamEqual(e).contramap(Seq::toStream);
    }

    public static <A> Equal<Stream<A>> streamEqual(Equal<A> ea) {
        Definition eaDef = ea.def;
        return Equal.equalDef((A a1, A a2) -> {
            Stream x1 = a1;
            Stream x2 = a2;
            while (x1.isNotEmpty() && x2.isNotEmpty()) {
                if (!eaDef.equal(x1.head(), x2.head())) {
                    return false;
                }
                x1 = x1.tail()._1();
                x2 = x2.tail()._1();
            }
            return x1.isEmpty() && x2.isEmpty();
        });
    }

    public static <A> Equal<Array<A>> arrayEqual(Equal<A> ea) {
        Definition eaDef = ea.def;
        return Equal.equalDef((A a1, A a2) -> {
            if (a1.length() == a2.length()) {
                for (int i = 0; i < a1.length(); ++i) {
                    if (eaDef.equal(a1.get(i), a2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    public static <A> Equal<Tree<A>> treeEqual(Equal<A> ea) {
        final Definition<A> eaDef = ea.def;
        return Equal.equalDef(new AltDefinition<Tree<A>>(){
            final Definition<P1<Stream<Tree<A>>>> subForestEqDef = Equal.access$000(Equal.p1Equal(Equal.streamEqual(Equal.equalDef(this))));

            @Override
            public boolean equal(Tree<A> t1, Tree<A> t2) {
                return eaDef.equal(t1.root(), t2.root()) && this.subForestEqDef.equal(t1.subForest(), t2.subForest());
            }
        });
    }

    public static <A> Equal<P1<A>> p1Equal(Equal<A> ea) {
        return ea.contramap(P1.__1());
    }

    public static <A, B> Equal<P2<A, B>> p2Equal(Equal<A> ea, Equal<B> eb) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()));
    }

    public static <A, B, C> Equal<P3<A, B, C>> p3Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()));
    }

    public static <A, B, C, D> Equal<P4<A, B, C, D>> p4Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec, Equal<D> ed) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        Definition edDef = ed.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()) && edDef.equal(p1._4(), p2._4()));
    }

    public static <A, B, C, D, E> Equal<P5<A, B, C, D, E>> p5Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec, Equal<D> ed, Equal<E> ee) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        Definition edDef = ed.def;
        Definition eeDef = ee.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()) && edDef.equal(p1._4(), p2._4()) && eeDef.equal(p1._5(), p2._5()));
    }

    public static <A, B, C, D, E, F$> Equal<P6<A, B, C, D, E, F$>> p6Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec, Equal<D> ed, Equal<E> ee, Equal<F$> ef) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        Definition edDef = ed.def;
        Definition eeDef = ee.def;
        Definition efDef = ef.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()) && edDef.equal(p1._4(), p2._4()) && eeDef.equal(p1._5(), p2._5()) && efDef.equal(p1._6(), p2._6()));
    }

    public static <A, B, C, D, E, F$, G> Equal<P7<A, B, C, D, E, F$, G>> p7Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec, Equal<D> ed, Equal<E> ee, Equal<F$> ef, Equal<G> eg) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        Definition edDef = ed.def;
        Definition eeDef = ee.def;
        Definition efDef = ef.def;
        Definition egDef = eg.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()) && edDef.equal(p1._4(), p2._4()) && eeDef.equal(p1._5(), p2._5()) && efDef.equal(p1._6(), p2._6()) && egDef.equal(p1._7(), p2._7()));
    }

    public static <A, B, C, D, E, F$, G, H> Equal<P8<A, B, C, D, E, F$, G, H>> p8Equal(Equal<A> ea, Equal<B> eb, Equal<C> ec, Equal<D> ed, Equal<E> ee, Equal<F$> ef, Equal<G> eg, Equal<H> eh) {
        Definition eaDef = ea.def;
        Definition ebDef = eb.def;
        Definition ecDef = ec.def;
        Definition edDef = ed.def;
        Definition eeDef = ee.def;
        Definition efDef = ef.def;
        Definition egDef = eg.def;
        Definition ehDef = eh.def;
        return Equal.equalDef((A p1, A p2) -> eaDef.equal(p1._1(), p2._1()) && ebDef.equal(p1._2(), p2._2()) && ecDef.equal(p1._3(), p2._3()) && edDef.equal(p1._4(), p2._4()) && eeDef.equal(p1._5(), p2._5()) && efDef.equal(p1._6(), p2._6()) && egDef.equal(p1._7(), p2._7()) && ehDef.equal(p1._8(), p2._8()));
    }

    public static <A> Equal<V2<A>> v2Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V2.toStream_());
    }

    public static <A> Equal<V3<A>> v3Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V3.toStream_());
    }

    public static <A> Equal<V4<A>> v4Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V4.toStream_());
    }

    public static <A> Equal<V5<A>> v5Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V5.toStream_());
    }

    public static <A> Equal<V6<A>> v6Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V6.toStream_());
    }

    public static <A> Equal<V7<A>> v7Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V7.toStream_());
    }

    public static <A> Equal<V8<A>> v8Equal(Equal<A> ea) {
        return Equal.streamEqual(ea).contramap(V8.toStream_());
    }

    public static <E, L extends HList<L>> Equal<HList.HCons<E, L>> hListEqual(Equal<E> e, Equal<L> l) {
        Definition eDef = e.def;
        Definition lDef = l.def;
        return Equal.equalDef((A c1, A c2) -> eDef.equal(c1.head(), c2.head()) && lDef.equal(c1.tail(), c2.tail()));
    }

    public static <A> Equal<Set<A>> setEqual(Equal<A> e) {
        return Equal.streamEqual(e).contramap(Set::toStream);
    }

    public static <K, V> Equal<TreeMap<K, V>> treeMapEqual(Equal<K> k, Equal<V> v) {
        return Equal.streamEqual(Equal.p2Equal(k, v)).contramap(TreeMap::toStream);
    }

    public static <A, B> Equal<Writer<A, B>> writerEqual(Equal<A> eq1, Equal<B> eq2) {
        return Equal.p2Equal(eq1, eq2).contramap(Writer::run);
    }

    public static <A> boolean equals0(Class<? super A> clazz, A self, Object other, Equal<A> equal) {
        return self == other || clazz.isInstance(other) && equal.eq(self, other);
    }

    public static <A> boolean equals0(Class<? super A> clazz, A self, Object other, F0<Equal<A>> equal) {
        return self == other || clazz.isInstance(other) && equal.f().eq(self, other);
    }

    static /* synthetic */ Definition access$000(Equal x0) {
        return x0.def;
    }

    public static interface AltDefinition<A>
    extends Definition<A> {
        @Override
        public boolean equal(A var1, A var2);

        @Override
        default public F<A, Boolean> equal(A a) {
            return a2 -> this.equal(a, a2);
        }
    }

    public static interface Definition<A> {
        public F<A, Boolean> equal(A var1);

        default public boolean equal(A a1, A a2) {
            return this.equal(a1).f(a2);
        }
    }
}

