/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.Function;
import fj.Ord;
import fj.Ordering;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Enumerator<A> {
    private final F<A, Option<A>> successor;
    private final F<A, Option<A>> predecessor;
    private final Option<A> max;
    private final Option<A> min;
    private final Ord<A> order;
    private final F<A, F<Long, Option<A>>> plus;
    public static final Enumerator<Boolean> booleanEnumerator = Enumerator.enumerator(b -> b != false ? Option.none() : Option.some(true), b -> b != false ? Option.some(false) : Option.none(), Option.some(true), Option.some(false), Ord.booleanOrd);
    public static final Enumerator<Byte> byteEnumerator = Enumerator.enumerator(b -> b == 127 ? Option.none() : Option.some((byte)(b + 1)), b -> b == -128 ? Option.none() : Option.some((byte)(b - 1)), Option.some((byte)127), Option.some((byte)-128), Ord.byteOrd);
    public static final Enumerator<Character> charEnumerator = Enumerator.enumerator(c -> c.charValue() == '\uffff' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() + '\u0001'))), c -> c.charValue() == '\u0000' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() - '\u0001'))), Option.some(Character.valueOf('\uffff')), Option.some(Character.valueOf('\u0000')), Ord.charOrd);
    public static final Enumerator<Double> doubleEnumerator = Enumerator.enumerator(d -> d == Double.MAX_VALUE ? Option.none() : Option.some(d + 1.0), d -> d == Double.MIN_VALUE ? Option.none() : Option.some(d - 1.0), Option.some(Double.MAX_VALUE), Option.some(Double.MIN_VALUE), Ord.doubleOrd);
    public static final Enumerator<Float> floatEnumerator = Enumerator.enumerator(f -> f.floatValue() == Float.MAX_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() + 1.0f)), f -> f.floatValue() == Float.MIN_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() - 1.0f)), Option.some(Float.valueOf(Float.MAX_VALUE)), Option.some(Float.valueOf(Float.MIN_VALUE)), Ord.floatOrd);
    public static final Enumerator<Integer> intEnumerator = Enumerator.enumerator(i -> i == Integer.MAX_VALUE ? Option.none() : Option.some(i + 1), i -> i == Integer.MIN_VALUE ? Option.none() : Option.some(i - 1), Option.some(Integer.MAX_VALUE), Option.some(Integer.MIN_VALUE), Ord.intOrd);
    public static final Enumerator<BigInteger> bigintEnumerator = Enumerator.enumerator(i -> Option.some(i.add(BigInteger.ONE)), i -> Option.some(i.subtract(BigInteger.ONE)), Option.none(), Option.none(), Ord.bigintOrd, Function.curry((i, l) -> Option.some(i.add(BigInteger.valueOf(l)))));
    public static final Enumerator<BigDecimal> bigdecimalEnumerator = Enumerator.enumerator(i -> Option.some(i.add(BigDecimal.ONE)), i -> Option.some(i.subtract(BigDecimal.ONE)), Option.none(), Option.none(), Ord.bigdecimalOrd, Function.curry((d, l) -> Option.some(d.add(BigDecimal.valueOf(l)))));
    public static final Enumerator<Long> longEnumerator = Enumerator.enumerator(i -> i == Long.MAX_VALUE ? Option.none() : Option.some(i + 1L), i -> i == Long.MIN_VALUE ? Option.none() : Option.some(i - 1L), Option.some(Long.MAX_VALUE), Option.some(Long.MIN_VALUE), Ord.longOrd);
    public static final Enumerator<Short> shortEnumerator = Enumerator.enumerator(i -> i == Short.MAX_VALUE ? Option.none() : Option.some((short)(i + 1)), i -> i == Short.MIN_VALUE ? Option.none() : Option.some((short)(i - 1)), Option.some((short)Short.MAX_VALUE), Option.some((short)Short.MIN_VALUE), Ord.shortOrd);
    public static final Enumerator<Ordering> orderingEnumerator = Enumerator.enumerator(o -> o == Ordering.LT ? Option.some(Ordering.EQ) : (o == Ordering.EQ ? Option.some(Ordering.GT) : Option.none()), o -> o == Ordering.GT ? Option.some(Ordering.EQ) : (o == Ordering.EQ ? Option.some(Ordering.LT) : Option.none()), Option.some(Ordering.GT), Option.some(Ordering.LT), Ord.orderingOrd);
    public static final Enumerator<Natural> naturalEnumerator = Enumerator.enumerator(n -> Option.some(n.succ()), Natural::pred, Option.none(), Option.some(Natural.ZERO), Ord.naturalOrd, Function.curry((n, l) -> Option.some(n).apply(Natural.natural(l).map(Function.curry((n1, n2) -> n1.add((Natural)n2))))));

    private Enumerator(F<A, Option<A>> successor, F<A, Option<A>> predecessor, Option<A> max, Option<A> min, Ord<A> order, F<A, F<Long, Option<A>>> plus) {
        this.successor = successor;
        this.predecessor = predecessor;
        this.max = max;
        this.min = min;
        this.order = order;
        this.plus = plus;
    }

    public F<A, Option<A>> successor() {
        return this.successor;
    }

    public Option<A> successor(A a) {
        return this.successor.f(a);
    }

    public F<A, Option<A>> predecessor() {
        return this.predecessor;
    }

    public Option<A> predecessor(A a) {
        return this.predecessor.f(a);
    }

    public Option<A> max() {
        return this.max;
    }

    public Option<A> min() {
        return this.min;
    }

    public F<A, F<Long, Option<A>>> plus() {
        return this.plus;
    }

    public F<Long, Option<A>> plus(A a) {
        return this.plus.f(a);
    }

    public F<A, Option<A>> plus(long l) {
        return Function.flip(this.plus).f(l);
    }

    public Option<A> plus(A a, long l) {
        return this.plus.f(a).f(l);
    }

    public Ord<A> order() {
        return this.order;
    }

    public <B> Enumerator<B> xmap(F<A, B> f, F<B, A> g) {
        F<Option, Option> of = o -> o.map(f);
        return Enumerator.enumerator(Function.compose(Function.compose(of, this.successor), g), Function.compose(Function.compose(of, this.predecessor), g), this.max.map(f), this.min.map(f), this.order.contramap(g), Function.compose(Function.compose(Function.compose().f(of), this.plus), g));
    }

    public Stream<A> toStream(A a) {
        F id = Function.identity();
        return Stream.fromFunction(this, id, a);
    }

    public Enumerator<A> setMin(Option<A> min) {
        return Enumerator.enumerator(this.successor, this.predecessor, this.max, min, this.order, this.plus);
    }

    public Enumerator<A> setMax(Option<A> max) {
        return Enumerator.enumerator(this.successor, this.predecessor, max, this.min, this.order, this.plus);
    }

    public static <A> Enumerator<A> enumerator(F<A, Option<A>> successor, F<A, Option<A>> predecessor, Option<A> max, Option<A> min, Ord<A> order, F<A, F<Long, Option<A>>> plus) {
        return new Enumerator<A>(successor, predecessor, max, min, order, plus);
    }

    public static <A> Enumerator<A> enumerator(F<A, Option<A>> successor, F<A, Option<A>> predecessor, Option<A> max, Option<A> min, Ord<A> order) {
        return new Enumerator<Object>(successor, predecessor, max, min, order, Function.curry((a, l) -> {
            if (l == 0L) {
                return Option.some(a);
            }
            if (l < 0L) {
                Object aa = a;
                for (long x = l.longValue(); x < 0L; ++x) {
                    Option s = (Option)predecessor.f(aa);
                    if (s.isNone()) {
                        return Option.none();
                    }
                    aa = s.some();
                }
                return Option.some(aa);
            }
            Object aa = a;
            for (long x = l.longValue(); x > 0L; --x) {
                Option s = (Option)successor.f(aa);
                if (s.isNone()) {
                    return Option.none();
                }
                aa = s.some();
            }
            return Option.some(aa);
        }));
    }
}

