/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Option;

public final class Integers {
    public static final F<Integer, F<Integer, Integer>> add = Semigroup.intAdditionSemigroup.sum();
    public static final F<Integer, F<Integer, Integer>> multiply = Semigroup.intMultiplicationSemigroup.sum();
    public static final F<Integer, F<Integer, Integer>> subtract = Function.curry((x, y) -> x - y);
    public static final F<Integer, Integer> negate = x -> x * -1;
    public static final F<Integer, Integer> abs = Math::abs;
    public static final F<Integer, F<Integer, Integer>> remainder = Function.curry((a, b) -> a % b);
    public static final F<Integer, F<Integer, Integer>> power = Function.curry((a, b) -> (int)StrictMath.pow(a.intValue(), b.intValue()));
    public static final F<Integer, Boolean> even = i -> i % 2 == 0;
    public static final F<Integer, Boolean> gtZero = i -> i > 0;
    public static final F<Integer, Boolean> gteZero = i -> i >= 0;
    public static final F<Integer, Boolean> ltZero = i -> i < 0;
    public static final F<Integer, Boolean> lteZero = i -> i <= 0;

    private Integers() {
        throw new UnsupportedOperationException();
    }

    public static int sum(List<Integer> ints) {
        return Monoid.intAdditionMonoid.sumLeft(ints);
    }

    public static int product(List<Integer> ints) {
        return Monoid.intMultiplicationMonoid.sumLeft(ints);
    }

    public static F<String, Option<Integer>> fromString() {
        return s -> {
            try {
                return Option.some(Integer.valueOf(s));
            }
            catch (NumberFormatException ignored) {
                return Option.none();
            }
        };
    }
}

