/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.Function;
import fj.data.List;
import fj.data.Stream;
import fj.function.Booleans;
import fj.function.Characters;
import java.util.regex.Pattern;

public final class Strings {
    private static final Pattern lineSeparatorPattern = Pattern.compile("\\r?\\n");
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final F<String, Boolean> isNotNullOrEmpty = a -> a != null && a.length() > 0;
    public static final F<String, Boolean> isNullOrEmpty = a -> a == null || a.length() == 0;
    public static final F<String, Boolean> isNotNullOrBlank = a -> isNotNullOrEmpty.f((String)a) != false && Stream.fromString(a).find(Booleans.not(Characters.isWhitespace)).isSome();
    public static final F<String, Boolean> isNullOrBlank = a -> isNullOrEmpty.f((String)a) != false || Stream.fromString(a).find(Booleans.not(Characters.isWhitespace)).isNone();
    public static final F<String, Boolean> isEmpty = s -> s.length() == 0;
    public static final F<String, Integer> length = String::length;
    public static final F<String, F<String, Boolean>> contains = Function.curry((s1, s2) -> s2.contains((CharSequence)s1));
    public static final F<String, F<String, Boolean>> matches = Function.curry((s1, s2) -> s2.matches((String)s1));

    private Strings() {
        throw new UnsupportedOperationException();
    }

    public static List<String> lines(String s) {
        return List.list(lineSeparatorPattern.split(s));
    }

    public static F<String, List<String>> lines() {
        return Strings::lines;
    }

    public static String unlines(List<String> list) {
        StringBuilder sb = new StringBuilder();
        list.intersperse(lineSeparator).foreachDoEffect(sb::append);
        return sb.toString();
    }

    public static F<List<String>, String> unlines() {
        return Strings::unlines;
    }
}

