/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.query;

import java.util.ArrayList;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.booleans.Predicate;
import org.sql.generation.api.grammar.builders.BooleanBuilder;
import org.sql.generation.api.grammar.builders.query.ColumnsBuilder;
import org.sql.generation.api.grammar.builders.query.FromBuilder;
import org.sql.generation.api.grammar.builders.query.GroupByBuilder;
import org.sql.generation.api.grammar.builders.query.OrderByBuilder;
import org.sql.generation.api.grammar.builders.query.QuerySpecificationBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.query.ColumnReference;
import org.sql.generation.api.grammar.query.ColumnReferences;
import org.sql.generation.api.grammar.query.FromClause;
import org.sql.generation.api.grammar.query.GroupByClause;
import org.sql.generation.api.grammar.query.GroupingElement;
import org.sql.generation.api.grammar.query.OrderByClause;
import org.sql.generation.api.grammar.query.OrdinaryGroupingSet;
import org.sql.generation.api.grammar.query.QuerySpecification;
import org.sql.generation.api.grammar.query.SelectColumnClause;
import org.sql.generation.implementation.grammar.query.QuerySpecificationImpl;

public class QuerySpecificationBuilderImpl
implements QuerySpecificationBuilder {
    private ColumnsBuilder _select;
    private FromBuilder _from;
    private BooleanBuilder _where;
    private GroupByBuilder _groupBy;
    private BooleanBuilder _having;
    private OrderByBuilder _orderBy;
    private final QueryFactory _queryFactory;

    public QuerySpecificationBuilderImpl(QueryFactory q, ColumnsBuilder select, FromBuilder from, BooleanBuilder where, GroupByBuilder groupBy, BooleanBuilder having, OrderByBuilder orderBy) {
        NullArgumentException.validateNotNull((String)"Query factory", (Object)q);
        NullArgumentException.validateNotNull((String)"select", (Object)select);
        NullArgumentException.validateNotNull((String)"from", (Object)from);
        NullArgumentException.validateNotNull((String)"where", (Object)where);
        NullArgumentException.validateNotNull((String)"group by", (Object)groupBy);
        NullArgumentException.validateNotNull((String)"having", (Object)having);
        NullArgumentException.validateNotNull((String)"order by", (Object)orderBy);
        this._queryFactory = q;
        this._select = select;
        this._from = from;
        this._where = where;
        this._groupBy = groupBy;
        this._having = having;
        this._orderBy = orderBy;
    }

    public FromBuilder getFrom() {
        return this._from;
    }

    public ColumnsBuilder getSelect() {
        return this._select;
    }

    public BooleanBuilder getWhere() {
        return this._where;
    }

    public GroupByBuilder getGroupBy() {
        return this._groupBy;
    }

    public BooleanBuilder getHaving() {
        return this._having;
    }

    public OrderByBuilder getOrderBy() {
        return this._orderBy;
    }

    public QuerySpecificationBuilder trimGroupBy() {
        if (this._having.createExpression() != Predicate.EmptyPredicate.INSTANCE) {
            ArrayList<ColumnReference> groupByColumns = new ArrayList<ColumnReference>();
            for (GroupingElement element : this._groupBy.getGroupingElements()) {
                if (!(element instanceof OrdinaryGroupingSet)) continue;
                for (NonBooleanExpression exp : ((OrdinaryGroupingSet)element).getColumns()) {
                    if (!(exp instanceof ColumnReference)) continue;
                    groupByColumns.add((ColumnReference)exp);
                }
            }
            for (ColumnReferences.ColumnReferenceInfo column : this._select.getColumns()) {
                Boolean noColumn = true;
                for (ColumnReference groupByColumn : groupByColumns) {
                    if (!column.getReference().equals(groupByColumn)) continue;
                    noColumn = false;
                    break;
                }
                if (!noColumn.booleanValue()) continue;
                this._groupBy.addGroupingElements(new GroupingElement[]{this._queryFactory.groupingElement(new NonBooleanExpression[]{column.getReference()})});
            }
        }
        return this;
    }

    public QuerySpecification createExpression() {
        return new QuerySpecificationImpl((SelectColumnClause)this._select.createExpression(), (FromClause)this._from.createExpression(), (BooleanExpression)this._where.createExpression(), (GroupByClause)this._groupBy.createExpression(), (BooleanExpression)this._having.createExpression(), (OrderByClause)this._orderBy.createExpression());
    }

    public QuerySpecificationBuilder setSelect(ColumnsBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._select = builder;
        return this;
    }

    public QuerySpecificationBuilder setFrom(FromBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._from = builder;
        return this;
    }

    public QuerySpecificationBuilder setWhere(BooleanBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._where = builder;
        return this;
    }

    public QuerySpecificationBuilder setGroupBy(GroupByBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._groupBy = builder;
        return this;
    }

    public QuerySpecificationBuilder setHaving(BooleanBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._having = builder;
        return this;
    }

    public QuerySpecificationBuilder setOrderBy(OrderByBuilder builder) {
        NullArgumentException.validateNotNull((String)"builder", (Object)builder);
        this._orderBy = builder;
        return this;
    }

    protected QueryFactory getQueryFactory() {
        return this._queryFactory;
    }
}

