/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import org.atp.api.Typeable;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.TableNameDirect;
import org.sql.generation.api.grammar.common.TableNameFunction;
import org.sql.generation.api.grammar.query.TableAlias;
import org.sql.generation.api.grammar.query.TableReferenceByExpression;
import org.sql.generation.api.grammar.query.TableReferenceByName;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.grammar.query.joins.CrossJoinedTable;
import org.sql.generation.api.grammar.query.joins.JoinCondition;
import org.sql.generation.api.grammar.query.joins.JoinType;
import org.sql.generation.api.grammar.query.joins.JoinedTable;
import org.sql.generation.api.grammar.query.joins.NamedColumnsJoin;
import org.sql.generation.api.grammar.query.joins.NaturalJoinedTable;
import org.sql.generation.api.grammar.query.joins.QualifiedJoinedTable;
import org.sql.generation.api.grammar.query.joins.UnionJoinedTable;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.ProcessorUtils;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class TableReferenceProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedColumnsJoinProcessor
    extends AbstractProcessor<NamedColumnsJoin> {
        public NamedColumnsJoinProcessor() {
            super(NamedColumnsJoin.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, NamedColumnsJoin join, StringBuilder builder) {
            builder.append(" ").append("USING").append(" ");
            processor.process((Typeable<?>)join.getColumnNames(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinConditionProcessor
    extends AbstractProcessor<JoinCondition> {
        public JoinConditionProcessor() {
            super(JoinCondition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, JoinCondition condition, StringBuilder builder) {
            builder.append(" ").append("ON").append(" ");
            processor.process((Typeable<?>)condition.getSearchConidition(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionJoinedTableProcessor
    extends JoinedTableProcessor<UnionJoinedTable> {
        public UnionJoinedTableProcessor() {
            super(UnionJoinedTable.class);
        }

        @Override
        protected void doProcessJoinedTable(SQLProcessorAggregator processor, UnionJoinedTable table, StringBuilder builder) {
            builder.append(" ").append("UNION JOIN").append(" ");
            processor.process(table.getRight().asTypeable(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QualifiedJoinedTableProcessor
    extends JoinedTableProcessor<QualifiedJoinedTable> {
        public QualifiedJoinedTableProcessor() {
            super(QualifiedJoinedTable.class);
        }

        @Override
        protected void doProcessJoinedTable(SQLProcessorAggregator processor, QualifiedJoinedTable table, StringBuilder builder) {
            this.processJoinType(table.getJoinType(), builder);
            processor.process(table.getRight().asTypeable(), builder);
            processor.process((Typeable<?>)table.getJoinSpecification(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NaturalJoinedTableProcessor
    extends JoinedTableProcessor<NaturalJoinedTable> {
        public NaturalJoinedTableProcessor() {
            super(NaturalJoinedTable.class);
        }

        @Override
        protected void doProcessJoinedTable(SQLProcessorAggregator processor, NaturalJoinedTable table, StringBuilder builder) {
            builder.append(" ").append("NATURAL").append(" ");
            this.processJoinType(table.getJoinType(), builder);
            builder.append(" ");
            processor.process(table.getRight().asTypeable(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CrossJoinedTableProcessor
    extends JoinedTableProcessor<CrossJoinedTable> {
        public CrossJoinedTableProcessor() {
            super(CrossJoinedTable.class);
        }

        @Override
        protected void doProcessJoinedTable(SQLProcessorAggregator processor, CrossJoinedTable table, StringBuilder builder) {
            builder.append(" ").append("CROSS JOIN").append(" ");
            processor.process(table.getRight().asTypeable(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class JoinedTableProcessor<JoinedTableType extends JoinedTable>
    extends AbstractProcessor<JoinedTableType> {
        public JoinedTableProcessor(Class<JoinedTableType> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, JoinedTableType table, StringBuilder builder) {
            processor.process(table.getLeft().asTypeable(), builder);
            builder.append("\n");
            this.doProcessJoinedTable(processor, table, builder);
        }

        protected abstract void doProcessJoinedTable(SQLProcessorAggregator var1, JoinedTableType var2, StringBuilder var3);

        protected void processJoinType(JoinType joinType, StringBuilder builder) {
            if (joinType != null) {
                if (joinType == JoinType.INNER) {
                    builder.append("INNER ");
                } else {
                    if (joinType == JoinType.FULL_OUTER) {
                        builder.append("FULL ");
                    }
                    if (joinType == JoinType.LEFT_OUTER) {
                        builder.append("LEFT ");
                    } else {
                        builder.append("RIGHT ");
                    }
                }
                builder.append("JOIN").append(" ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableReferenceByExpressionProcessor
    extends TableReferencePrimaryProcessor<TableReferenceByExpression> {
        public TableReferenceByExpressionProcessor() {
            super(TableReferenceByExpression.class);
        }

        @Override
        protected void doProcessTablePrimary(SQLProcessorAggregator processor, TableReferenceByExpression tableRef, StringBuilder builder) {
            builder.append("(");
            processor.process((Typeable<?>)tableRef.getQuery(), builder);
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableReferenceByNameProcessor
    extends TableReferencePrimaryProcessor<TableReferenceByName> {
        public TableReferenceByNameProcessor() {
            super(TableReferenceByName.class);
        }

        @Override
        protected void doProcessTablePrimary(SQLProcessorAggregator processor, TableReferenceByName object, StringBuilder builder) {
            processor.process((Typeable<?>)object.getTableName(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TableReferencePrimaryProcessor<TableReferenceType extends TableReferencePrimary>
    extends AbstractProcessor<TableReferenceType> {
        public TableReferencePrimaryProcessor(Class<TableReferenceType> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, TableReferenceType object, StringBuilder builder) {
            this.doProcessTablePrimary(processor, object, builder);
            if (object.getTableAlias() != null) {
                this.processTableAlias(processor, object.getTableAlias(), builder);
            }
        }

        protected abstract void doProcessTablePrimary(SQLProcessorAggregator var1, TableReferenceType var2, StringBuilder var3);

        protected void processTableAlias(SQLProcessorAggregator processor, TableAlias tableAlias, StringBuilder builder) {
            String alias = tableAlias.getTableAlias();
            if (ProcessorUtils.notNullAndNotEmpty(alias).booleanValue()) {
                builder.append(" ").append("AS").append(" ").append(alias);
                if (tableAlias.getColumnAliases() != null) {
                    processor.process((Typeable<?>)tableAlias.getColumnAliases(), builder);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableNameDirectProcessor
    extends AbstractTableNameProcessor<TableNameDirect> {
        public TableNameDirectProcessor() {
            this((Class<? extends TableNameDirect>)TableNameDirect.class);
        }

        protected TableNameDirectProcessor(Class<? extends TableNameDirect> realType) {
            super(realType);
        }

        @Override
        protected void doProcessTableName(SQLProcessorAggregator processor, TableNameDirect object, StringBuilder builder) {
            builder.append(object.getTableName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableNameFunctionProcessor
    extends AbstractTableNameProcessor<TableNameFunction> {
        public TableNameFunctionProcessor() {
            this((Class<? extends TableNameFunction>)TableNameFunction.class);
        }

        protected TableNameFunctionProcessor(Class<? extends TableNameFunction> realType) {
            super(realType);
        }

        @Override
        protected void doProcessTableName(SQLProcessorAggregator processor, TableNameFunction object, StringBuilder builder) {
            processor.process((Typeable<?>)object.getFunction(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractTableNameProcessor<TableNameType extends TableName>
    extends AbstractProcessor<TableNameType> {
        protected AbstractTableNameProcessor(Class<? extends TableNameType> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, TableNameType object, StringBuilder builder) {
            String schemaName = object.getSchemaName();
            if (ProcessorUtils.notNullAndNotEmpty(schemaName).booleanValue()) {
                builder.append(schemaName).append(".");
            }
            this.doProcessTableName(processor, object, builder);
        }

        protected abstract void doProcessTableName(SQLProcessorAggregator var1, TableNameType var2, StringBuilder var3);
    }
}

