/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.error;

import com.jd.laf.web.vertx.response.ErrorSupplier;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.joyqueue.exception.ServiceException;
import org.joyqueue.handler.error.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;

public class ThrowableSupplier
implements ErrorSupplier {
    private static final Logger logger = LoggerFactory.getLogger(ThrowableSupplier.class);

    public Response error(Throwable throwable) {
        logger.error("throwable exception", throwable);
        if (throwable instanceof IllegalArgumentException) {
            return Responses.error((int)ErrorCode.BadRequest.getCode(), (int)ErrorCode.BadRequest.getStatus(), (String)throwable.getMessage());
        }
        if (throwable instanceof DuplicateKeyException) {
            return Responses.error((int)ErrorCode.DuplicateError.getCode(), (int)ErrorCode.DuplicateError.getStatus(), (String)"\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        if (throwable instanceof DataIntegrityViolationException) {
            return Responses.error((int)ErrorCode.RuntimeError.getCode(), (int)ErrorCode.RuntimeError.getStatus(), (String)"\u8f93\u5165\u8bb0\u5f55\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (throwable instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)throwable).getTargetException();
            if (targetException instanceof ServiceException) {
                ServiceException serviceException = (ServiceException)targetException;
                return Responses.error((int)ErrorCode.ServiceError.getCode(), (int)serviceException.getStatus(), (String)serviceException.getMessage());
            }
            return Responses.error((int)ErrorCode.RuntimeError.getCode(), (int)ErrorCode.RuntimeError.getStatus(), (String)targetException.getMessage());
        }
        if (throwable instanceof NullPointerException) {
            return Responses.error((int)ErrorCode.RuntimeError.getCode(), (int)ErrorCode.RuntimeError.getStatus(), (String)((NullPointerException)throwable).toString());
        }
        return Responses.error((int)ErrorCode.RuntimeError.getCode(), (int)ErrorCode.RuntimeError.getStatus(), (String)(StringUtils.isNotBlank((String)throwable.toString()) ? throwable.toString() : ErrorCode.RuntimeError.getMessage()));
    }

    public Class<? extends Throwable> type() {
        return Throwable.class;
    }
}

