/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.message;

import com.jd.laf.web.vertx.MessageHandler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.joyqueue.handler.message.AuditLogMessage;

public class AuditLogMessageHandler
implements MessageHandler<AuditLogMessage> {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogMessageHandler.class);
    public static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public String type() {
        return "auditLogMessage";
    }

    public void handle(Message<AuditLogMessage> message) {
        if (message != null) {
            AuditLogMessage auditLog = (AuditLogMessage)message.body();
            Instant instant = auditLog.getTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            if (auditLog.getTarget() != null) {
                logger.info((Object)String.format("%s\u5728\u65f6\u95f4\u70b9%s\u4e3a%s%s%s", auditLog.getUser(), localDateTime.format(FORMAT), auditLog.getTarget(), auditLog.getType().description(), auditLog.message));
            } else {
                logger.info((Object)String.format("%s\u5728\u65f6\u95f4\u70b9%s%s%s", auditLog.getUser(), localDateTime.format(FORMAT), auditLog.getType().description(), auditLog.message));
            }
        }
    }
}

