/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.handler.RemoteIpHandler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import javax.validation.constraints.NotNull;
import org.joyqueue.model.domain.User;
import org.joyqueue.service.UserService;

public class AdminLoginHandler
extends RemoteIpHandler {
    @Value(value="user.session.key", defaultValue="user")
    protected String userSessionKey;
    @Value
    @NotNull
    protected UserService userService;
    protected static final String DEFAULT_LOGIN_USER_CODE = "admin";

    public String type() {
        return "AdminLogin";
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        Session session = context.session();
        if (session == null) {
            context.fail((Throwable)new HttpStatusException(500, "No session - did you forget to include a SessionHandler?"));
            return;
        }
        String remoteIP = AdminLoginHandler.getRemoteIP((HttpServerRequest)request);
        context.put("remoteIp", (Object)remoteIP);
        User user = (User)session.get(this.userSessionKey);
        if (user == null) {
            user = this.userService.findByCode(DEFAULT_LOGIN_USER_CODE);
        }
        context.put("userDetail", (Object)user);
        context.next();
    }
}

