/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.CVertx;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.Vertx;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.exception.ValidationException;
import org.joyqueue.handler.annotation.GenericValue;
import org.joyqueue.handler.annotation.Operator;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.message.AuditLogMessage;
import org.joyqueue.handler.message.MessageType;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QKeyword;
import org.joyqueue.model.QOperator;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.Query;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identifier;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.OperLog;
import org.joyqueue.model.domain.User;
import org.joyqueue.service.PageService;

public abstract class CommandSupport<M extends BaseModel, S extends PageService, Q extends Query>
implements Command<Response>,
Poolable {
    @GenericValue
    protected S service;
    @Value(value="userDetail")
    protected User session;
    @Operator
    protected Identity operator;
    @CVertx
    protected Vertx vertx;

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    public void clean() {
        this.service = null;
        this.session = null;
        this.operator = null;
    }

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<Q> qPageQuery) throws Exception {
        Preconditions.checkArgument((qPageQuery != null ? 1 : 0) != 0, (Object)"Illegal args.");
        if (qPageQuery.getQuery() != null) {
            if (qPageQuery.getQuery() instanceof QOperator) {
                QOperator query = (QOperator)qPageQuery.getQuery();
                query.setUserId(Long.valueOf(this.session.getId()));
                query.setRole(this.session.getRole());
                query.setUserCode(this.session.getCode());
                query.setUserName(this.session.getName());
                query.setAdmin(this.session.getRole() == User.UserRole.ADMIN.value() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (qPageQuery.getQuery() instanceof QKeyword) {
                String keyword = ((QKeyword)qPageQuery.getQuery()).getKeyword();
                ((QKeyword)qPageQuery.getQuery()).setKeyword(StringUtils.isBlank((CharSequence)keyword) ? null : keyword.trim());
            }
        }
        PageResult result = this.service.findByQuery(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="add")
    public Response add(@Body M model) throws Exception {
        int count;
        model.setCreateBy(new Identity((Identifier)this.session));
        model.setCreateTime(new Date());
        model.setUpdateBy(model.getCreateBy());
        model.setUpdateTime(new Date());
        try {
            count = this.service.add(model);
        }
        catch (ValidationException e) {
            return Responses.error((int)ErrorCode.ValidationError.getCode(), (int)e.getStatus(), (String)e.getMessage());
        }
        if (count <= 0) {
            throw new ConfigException(this.addErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.ADD, OperLog.OperType.ADD, model);
        return Responses.success(model);
    }

    @Path(value="delete")
    public Response delete(@QueryParam(value="id") Long id) throws Exception {
        BaseModel newModel = this.service.findById(id.longValue());
        newModel.setStatus(-1);
        newModel.setUpdateBy(this.operator);
        newModel.setUpdateTime(new Date());
        int count = this.service.delete(newModel);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.DELETE, OperLog.OperType.DELETE, newModel);
        return Responses.success();
    }

    @Path(value="get")
    public Response get(@QueryParam(value="id") Long id) throws Exception {
        BaseModel model = this.service.findById(id.longValue());
        if (model == null) {
            throw new ConfigException(this.getErrorCode());
        }
        return Responses.success((Object)model);
    }

    @Path(value="update")
    public Response update(@QueryParam(value="id") Long id, @Body M model) throws Exception {
        int count;
        model.setUpdateBy(this.operator);
        model.setUpdateTime(new Date());
        try {
            count = this.service.update(model);
        }
        catch (ValidationException e) {
            return Responses.error((int)ErrorCode.ValidationError.getCode(), (int)e.getStatus(), (String)e.getMessage());
        }
        if (count < 1) {
            throw new ConfigException(this.updateErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.UPDATE, OperLog.OperType.UPDATE, model);
        return Responses.success(model);
    }

    @Path(value="state")
    public Response updateStatus(@QueryParam(value="id") Long id, @Body M model) throws Exception {
        model.setUpdateBy(this.operator);
        model.setUpdateTime(new Date());
        int count = this.service.updateStatus(model);
        if (count < 1) {
            throw new ConfigException(this.updateErrorCode());
        }
        return Responses.success(model);
    }

    public ErrorCode addErrorCode() {
        return ErrorCode.NoDataAdded;
    }

    public ErrorCode deleteErrorCode() {
        return ErrorCode.NoDataDeleted;
    }

    public ErrorCode updateErrorCode() {
        return ErrorCode.NoDataUpdated;
    }

    public ErrorCode getErrorCode() {
        return ErrorCode.NoDataExists;
    }

    public void publish(AuditLogMessage.ActionType auditType, OperLog.OperType operType, M model) {
        if (model == null) {
            return;
        }
        if (auditType != null) {
            String type = this.type();
            this.vertx.eventBus().send(MessageType.AUDIT_LOG.value(), (Object)new AuditLogMessage(this.operator.getCode(), type + "(" + model.toString() + ")", auditType, type + "(" + JSON.toJSONString(model) + ")"));
        }
    }
}

