/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command;

import com.alibaba.fastjson.JSON;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.CVertx;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.Vertx;
import org.joyqueue.exception.ValidationException;
import org.joyqueue.handler.annotation.GenericValue;
import org.joyqueue.handler.annotation.Operator;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.message.AuditLogMessage;
import org.joyqueue.handler.message.MessageType;
import org.joyqueue.model.Query;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.OperLog;
import org.joyqueue.model.domain.User;
import org.joyqueue.nsr.NsrService;

public abstract class NsrCommandSupport<M, S extends NsrService, Q extends Query>
implements Command<Response>,
Poolable {
    @GenericValue
    protected S service;
    @Value(value="userDetail")
    protected User session;
    @Operator
    protected Identity operator;
    @CVertx
    protected Vertx vertx;

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    public void clean() {
        this.service = null;
        this.session = null;
        this.operator = null;
    }

    @Path(value="add")
    public Response add(@Body M model) throws Exception {
        int count;
        try {
            count = this.service.add(model);
        }
        catch (ValidationException e) {
            return Responses.error((int)ErrorCode.ValidationError.getCode(), (int)e.getStatus(), (String)e.getMessage());
        }
        if (count <= 0) {
            throw new ConfigException(this.addErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.ADD, OperLog.OperType.ADD, model);
        return Responses.success(model);
    }

    @Path(value="delete")
    public Response delete(@QueryParam(value="id") String id) throws Exception {
        Object newModel = this.service.findById((Object)id);
        if (newModel == null) {
            throw new ConfigException(this.deleteErrorCode());
        }
        int count = this.service.delete(newModel);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.DELETE, OperLog.OperType.DELETE, newModel);
        return Responses.success();
    }

    @Path(value="get")
    public Response get(@QueryParam(value="id") String id) throws Exception {
        Object model = this.service.findById((Object)id);
        if (model == null) {
            throw new ConfigException(this.getErrorCode());
        }
        return Responses.success((Object)model);
    }

    @Path(value="update")
    public Response update(@QueryParam(value="id") String id, @Body M model) throws Exception {
        int count;
        try {
            count = this.service.update(model);
        }
        catch (ValidationException e) {
            return Responses.error((int)ErrorCode.ValidationError.getCode(), (int)e.getStatus(), (String)e.getMessage());
        }
        if (count < 1) {
            throw new ConfigException(this.updateErrorCode());
        }
        this.publish(AuditLogMessage.ActionType.UPDATE, OperLog.OperType.UPDATE, model);
        return Responses.success(model);
    }

    @Path(value="state")
    public Response updateStatus(@QueryParam(value="id") String id, @Body M model) throws Exception {
        int count = this.service.update(model);
        if (count < 1) {
            throw new ConfigException(this.updateErrorCode());
        }
        return Responses.success(model);
    }

    public ErrorCode addErrorCode() {
        return ErrorCode.NoDataAdded;
    }

    public ErrorCode deleteErrorCode() {
        return ErrorCode.NoDataDeleted;
    }

    public ErrorCode updateErrorCode() {
        return ErrorCode.NoDataUpdated;
    }

    public ErrorCode getErrorCode() {
        return ErrorCode.NoDataExists;
    }

    public void publish(AuditLogMessage.ActionType auditType, OperLog.OperType operType, M model) {
        if (model == null) {
            return;
        }
        if (auditType != null) {
            String type = this.type();
            this.vertx.eventBus().send(MessageType.AUDIT_LOG.value(), (Object)new AuditLogMessage(this.operator.getCode(), type + "(" + JSON.toJSONString(model) + ")", auditType, type + "(" + model.toString() + ")"));
        }
    }
}

