/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.application;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.CommandSupport;
import org.joyqueue.model.ListQuery;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QApplication;
import org.joyqueue.service.ApplicationService;
import org.joyqueue.service.UserService;

public class ApplicationCommand
extends CommandSupport<Application, ApplicationService, QApplication> {
    @Value
    @NotNull
    protected UserService userService;

    @Override
    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QApplication> qPageQuery) throws Exception {
        boolean admin;
        boolean bl = admin = this.session.getRole() == User.UserRole.ADMIN.value();
        if (qPageQuery.getQuery() == null) {
            qPageQuery.setQuery((Object)(admin ? new QApplication() : new QApplication(this.operator.getId())));
        } else {
            ((QApplication)qPageQuery.getQuery()).setUserId(admin ? null : this.operator.getId());
        }
        return super.pageQuery(qPageQuery);
    }

    @Path(value="searchSubscribed")
    public Response searchSubscribed(@PageQuery QPageQuery<QApplication> qPageQuery) throws Exception {
        QApplication qApplication = (QApplication)qPageQuery.getQuery();
        if (qApplication == null) {
            throw new ConfigException(ErrorCode.BadRequest);
        }
        qApplication.setUserId(Long.valueOf(this.session.getId()));
        qApplication.setAdmin(this.session.getRole() == User.UserRole.ADMIN.value() ? Boolean.TRUE : Boolean.FALSE);
        qApplication.setKeyword(qApplication.getKeyword() == null ? null : qApplication.getKeyword().trim());
        PageResult result = ((ApplicationService)this.service).findSubscribedByQuery(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="searchUnsubscribed")
    public Response searchUnsubscribed(@PageQuery QPageQuery<QApplication> qPageQuery) throws Exception {
        QApplication qApplication = (QApplication)qPageQuery.getQuery();
        if (qApplication == null) {
            throw new ConfigException(ErrorCode.BadRequest);
        }
        qApplication.setUserId(Long.valueOf(this.session.getId()));
        qApplication.setAdmin(this.session.getRole() == User.UserRole.ADMIN.value() ? Boolean.TRUE : Boolean.FALSE);
        qApplication.setKeyword(qApplication.getKeyword() == null ? null : qApplication.getKeyword().trim());
        PageResult result = ((ApplicationService)this.service).findTopicUnsubscribedByQuery(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="findAll")
    public Response findAll() throws Exception {
        return Responses.success((Object)((ApplicationService)this.service).findByQuery(new ListQuery((Object)new QApplication())));
    }

    @Path(value="setOwner")
    public Response setOwner(@QueryParam(value="id") Long id, @QueryParam(value="userId") Long userId) throws Exception {
        Application application = (Application)((ApplicationService)this.service).findById(id.longValue());
        User user = (User)this.userService.findById(userId.longValue());
        application.setOwner(new Identity(Long.valueOf(user.getId()), user.getCode()));
        return Responses.success((Object)((ApplicationService)this.service).update((BaseModel)application));
    }

    @Path(value="getByCode")
    public Response getByCode(@QueryParam(value="appCode") String appCode) throws Exception {
        return Responses.success((Object)((ApplicationService)this.service).findByCode(appCode));
    }
}

