/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.application;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.Collections;
import java.util.List;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.ApplicationToken;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.query.QApplicationToken;
import org.joyqueue.service.ApplicationTokenService;

public class ApplicationTokenCommand
extends NsrCommandSupport<ApplicationToken, ApplicationTokenService, QApplicationToken> {
    @Value(value="application")
    protected Application application;

    @Path(value="search")
    public Response search(@PageQuery QPageQuery<QApplicationToken> qPageQuery) throws Exception {
        QApplicationToken query = (QApplicationToken)qPageQuery.getQuery();
        List appTokens = Collections.emptyList();
        if (query.getApplication() != null) {
            appTokens = ((ApplicationTokenService)this.service).findByApp(query.getApplication().getCode());
        }
        if (this.application != null) {
            appTokens = ((ApplicationTokenService)this.service).findByApp(this.application.getCode());
        }
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(appTokens.size());
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(appTokens);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="getByApp")
    public Response pageQuery(@PageQuery QPageQuery<QApplicationToken> qPageQuery) throws Exception {
        QApplicationToken query = (QApplicationToken)qPageQuery.getQuery();
        query.setApplication(new Identity(this.application.getCode()));
        List appTokenList = ((ApplicationTokenService)this.service).findByApp(this.application.getId());
        PageResult result = new PageResult();
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(appTokenList.size());
        pagination.setSize(appTokenList.size());
        result.setPagination(pagination);
        result.setResult(appTokenList);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Override
    @Path(value="add")
    public Response add(@Body ApplicationToken model) throws Exception {
        int tokenCount = ((ApplicationTokenService)this.service).countByAppId(this.application.getId());
        if (tokenCount >= 5) {
            throw new ConfigException(ErrorCode.ExcessiveToken);
        }
        model.setApplication(this.application.identity());
        ((ApplicationTokenService)this.service).add((Object)model);
        return Responses.success();
    }

    @Path(value="getByAppId")
    public Response findByAppId(@QueryParam(value="appId") long appId) throws Exception {
        return Responses.success((Object)((ApplicationTokenService)this.service).findByApp(appId));
    }

    @Override
    @Path(value="update")
    public Response update(@QueryParam(value="id") String id, @Body ApplicationToken model) throws Exception {
        model.initializeTime();
        model.setApplication(this.application.identity());
        return Responses.success((Object)((ApplicationTokenService)this.service).update((Object)model));
    }

    @Override
    @Path(value="delete")
    public Response delete(@QueryParam(value="id") String id) throws Exception {
        ApplicationToken newModel = (ApplicationToken)((ApplicationTokenService)this.service).findById((Object)Long.valueOf(id));
        int count = ((ApplicationTokenService)this.service).delete((Object)newModel);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success();
    }
}

