/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.application;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.Date;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.CommandSupport;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.ApplicationUser;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QUser;
import org.joyqueue.service.ApplicationService;
import org.joyqueue.service.ApplicationUserService;
import org.joyqueue.service.UserService;

public class ApplicationUserCommand
extends CommandSupport<ApplicationUser, UserService, QUser> {
    @QueryParam(value="appId")
    protected Long appId;
    @Value(nullable=false)
    protected UserService userService;
    @Value(nullable=false)
    protected ApplicationUserService applicationUserService;
    @Value(nullable=false)
    protected ApplicationService applicationService;
    @Value(value="application")
    protected Application application;

    @Override
    @Path(value="add")
    public Response add(@Body ApplicationUser applicationUser) throws Exception {
        User user;
        if (applicationUser.getUser() == null) {
            throw new ConfigException(ErrorCode.BadRequest, "\u6ca1\u6709\u4f20\u5165User\u53c2\u6570!");
        }
        if (null == this.application) {
            throw new ConfigException(ErrorCode.BadRequest, "\u627e\u4e0d\u5230\u6b64\u5e94\u7528!");
        }
        applicationUser.setApplication(this.application.identity());
        applicationUser.setCreateBy(this.operator);
        applicationUser.setUpdateBy(this.operator);
        Identity userIdentity = applicationUser.getUser();
        User user2 = user = userIdentity.getId() != null ? (User)this.userService.findById(userIdentity.getId().longValue()) : this.userService.findByCode(userIdentity.getCode());
        if (user == null) {
            return Responses.error((int)404, (String)"\u586b\u5199\u8d26\u53f7\u5728\u6b64\u7cfb\u7edf\u627e\u4e0d\u5230");
        }
        applicationUser.setUser(user.identity());
        int count = this.applicationUserService.add((BaseModel)applicationUser);
        if (count <= 0) {
            throw new ConfigException(this.addErrorCode());
        }
        return Responses.success((Object)applicationUser);
    }

    @Override
    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QUser> qPageQuery) throws Exception {
        if (qPageQuery.getQuery() == null) {
            QUser qUser = new QUser();
            qUser.setAppId(this.appId);
            qPageQuery.setQuery((Object)new QUser());
        } else {
            ((QUser)qPageQuery.getQuery()).setAppId(this.appId);
        }
        return super.pageQuery(qPageQuery);
    }

    @Path(value="getByAppCode")
    public Response getByAppCode(@QueryParam(value="appCode") String appCode) throws Exception {
        Application app = this.applicationService.findByCode(appCode);
        if (app == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists, String.format("can not app find by code %s", appCode));
        }
        QPageQuery qPageQuery = new QPageQuery();
        QUser qUser = new QUser();
        qUser.setAppId(Long.valueOf(app.getId()));
        qPageQuery.setQuery((Object)qUser);
        qPageQuery.setPagination(Pagination.newPagination((Integer)0, (Integer)Integer.MAX_VALUE));
        return super.pageQuery(qPageQuery);
    }

    @Path(value="delete")
    public Response delete(@QueryParam(value="appId") Long appId, @QueryParam(value="userId") Long userId) throws Exception {
        ApplicationUser appUser = ((UserService)this.service).findAppUserByAppIdAndUserId(appId.longValue(), userId.longValue());
        appUser.setStatus(-1);
        appUser.setUpdateBy(this.operator);
        appUser.setUpdateTime(new Date());
        this.applicationUserService.deleteById(appUser.getId());
        return Responses.success();
    }

    @Override
    public void clean() {
        super.clean();
        this.applicationUserService = null;
        this.appId = null;
        this.userService = null;
        this.applicationService = null;
        this.application = null;
    }
}

