/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.application;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.CVertx;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.Vertx;
import javax.validation.constraints.NotNull;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.Identifier;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.User;
import org.joyqueue.sync.ApplicationInfo;
import org.joyqueue.sync.SyncService;

public class SyncApplicationCommand
implements Command<Response>,
Poolable {
    @Value(nullable=false)
    protected SyncService syncService;
    @Body(type=Body.BodyType.JSON)
    @NotNull
    protected Application application;
    @Value(value="userDetail")
    protected User session;
    @CVertx
    private Vertx vertx;

    public String type() {
        return "syncApp";
    }

    public Response execute() throws Exception {
        this.application.setErp(this.session.getCode());
        ApplicationInfo info = this.syncService.syncApp(this.application);
        if (info == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists);
        }
        info.setUser(new Identity((Identifier)this.session));
        return Responses.success((Object)this.syncService.addOrUpdateApp(info));
    }

    public void clean() {
        this.application = null;
        this.session = null;
    }
}

