/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.archive;

import com.google.common.base.Strings;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.CRequest;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.util.Bytes;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.model.domain.Archive;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QArchive;
import org.joyqueue.server.archive.store.model.SendLog;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.service.ArchiveService;
import org.joyqueue.service.RetryService;
import org.joyqueue.util.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveCommand
implements Command<Response>,
Poolable {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveCommand.class);
    @Value(nullable=false)
    private ArchiveService archiveService;
    @Value(nullable=false)
    private RetryService retryService;
    @Value(value="userDetail")
    protected User session;
    @CRequest
    private HttpServerRequest request;

    @Path(value="search")
    public Response pageQuery(@Body QArchive qArchive) throws Exception {
        if (Strings.isNullOrEmpty((String)qArchive.getTopic()) || qArchive.getBeginTime() == null || qArchive.getEndTime() == null) {
            return Responses.error((int)400, (String)"beginTime,endTime,topic \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Responses.success((Object)this.archiveService.findByQuery(qArchive));
    }

    @Path(value="consume")
    public Response consume(@QueryParam(value="id") Object messageId) throws Exception {
        return Responses.success((Object)this.archiveService.findConsumeLog(String.valueOf(messageId), Integer.valueOf(100)));
    }

    @Path(value="retry")
    public Response archive2retry(@Body Archive archive) throws Exception {
        if (archive == null || archive.getBusinessId() == null || archive.getMessageId() == null || archive.getSendTime() == null || archive.getTopic() == null) {
            return Responses.error((int)400, (String)"topic,sendTime,businessId,messageId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        SendLog sendLog = this.archiveService.findSendLog(archive.getTopic(), archive.getSendTime(), archive.getBusinessId(), archive.getMessageId());
        this.retryService.add(this.convertMessageLog(sendLog, archive.getApp()));
        return Responses.success();
    }

    @Path(value="download")
    public void download(@QueryParam(value="businessId") String businessId, @QueryParam(value="messageId") String messageId, @QueryParam(value="sendTime") String sendTime, @QueryParam(value="topic") String topic) throws Exception {
        if (businessId == null || messageId == null || sendTime == null || topic == null) {
            return;
        }
        SendLog sendLog = this.archiveService.findSendLog(topic, Long.valueOf(sendTime), businessId, messageId);
        if (sendLog != null) {
            HttpServerResponse response = this.request.response();
            byte[] data = sendLog.getMessageBody();
            if (data.length == 0) {
                throw new JoyQueueException("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a", 400);
            }
            String fileName = sendLog.getMessageId() + ".txt";
            response.reset();
            BrokerMessage brokerMessage = Serializer.readBrokerMessage((ByteBuffer)ByteBuffer.wrap(data));
            String messageStr = null;
            try {
                messageStr = brokerMessage.getText();
            }
            catch (Exception e) {
                messageStr = Bytes.toString((byte[])data);
            }
            if (messageStr == null) {
                messageStr = "";
            }
            response.putHeader("Content-Disposition", "attachment;fileName=" + fileName).putHeader("content-type", "text/plain").putHeader("Content-Length", String.valueOf(messageStr.getBytes().length));
            response.write(messageStr, "UTF-8");
            response.end();
        }
    }

    @Path(value="isServerEnabled")
    public Response isServerEnabled() throws Exception {
        return Responses.success((Object)this.archiveService.isServerEnabled());
    }

    private String convertParams(QArchive qArchive) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"beginTime\":").append(qArchive.getBeginTime().getTime()).append(",").append("\"endTime\":").append(qArchive.getEndTime().getTime()).append(",").append("\"count\":").append(qArchive.getCount()).append(",").append("\"messageId\":").append("\"").append(qArchive.getMessageId()).append("\"").append(",").append("\"topic\":").append("\"").append(qArchive.getTopic()).append("\"").append("}");
        return builder.toString();
    }

    private RetryMessageModel convertMessageLog(SendLog sendLog, String app) throws Exception {
        RetryMessageModel retry = this.retryConvert(sendLog, app);
        retry.setBrokerMessage(sendLog.getMessageBody());
        return retry;
    }

    private RetryMessageModel retryConvert(SendLog sendLog, String app) {
        RetryMessageModel retry = new RetryMessageModel();
        retry.setApp(app);
        retry.setTopic(sendLog.getTopic());
        retry.setBusinessId(sendLog.getBusinessId());
        retry.setPartition((short)255);
        return retry;
    }

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    public String type() {
        return "archive";
    }

    public void clean() {
    }
}

