/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.broker;

import com.google.common.base.Preconditions;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Broker;
import org.joyqueue.model.query.QBroker;
import org.joyqueue.service.BrokerService;

public class BrokerCommand
extends NsrCommandSupport<Broker, BrokerService, QBroker> {
    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QBroker> qPageQuery) throws Exception {
        Preconditions.checkArgument((qPageQuery != null ? 1 : 0) != 0, (Object)"Illegal args.");
        PageResult result = ((BrokerService)this.service).search(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Override
    @Path(value="delete")
    public Response delete(@QueryParam(value="id") String id) throws Exception {
        Broker newModel = (Broker)((BrokerService)this.service).findById((Object)Integer.valueOf(id));
        int count = ((BrokerService)this.service).delete((Object)newModel);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success();
    }

    @Path(value="get")
    public Response get(@QueryParam(value="id") Long id) throws Exception {
        Broker newModel = (Broker)((BrokerService)this.service).findById((Object)Integer.valueOf(String.valueOf(id)));
        if (newModel == null) {
            throw new ConfigException(this.getErrorCode());
        }
        return Responses.success((Object)newModel);
    }

    @Path(value="findByTopic")
    public Response findByTopic(@Body(type=Body.BodyType.TEXT) String topicFullName) throws Exception {
        return Responses.success((Object)((BrokerService)this.service).findByTopic(topicFullName));
    }

    @Path(value="telnet")
    public Response telnet(@QueryParam(value="ip") String ip, @QueryParam(value="port") int port) throws Exception {
        TelnetClient telnetClient = new TelnetClient("vt200");
        telnetClient.setDefaultTimeout(5000);
        try {
            telnetClient.connect(ip, port);
        }
        catch (Exception e) {
            return Responses.error((int)500, (String)"\u672a\u5b58\u6d3b");
        }
        return Responses.success();
    }
}

