/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.chart;

import com.google.common.base.Preconditions;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Context;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.exception.ServiceException;
import org.joyqueue.handler.util.GrafanaUtils;
import org.joyqueue.model.domain.grafana.GrafanaSearch;
import org.joyqueue.model.domain.grafana.GrafanaVariable;
import org.joyqueue.model.domain.grafana.GrafanaVariableParameter;
import org.joyqueue.model.domain.grafana.GrafanaVariableResult;
import org.joyqueue.util.NullUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaCommand
implements Command<Response>,
Poolable {
    private static final Logger logger = LoggerFactory.getLogger(GrafanaCommand.class);
    @Context
    protected RoutingContext context;

    @Path(value="test")
    public Response test() throws Exception {
        return Responses.success();
    }

    @Path(value="search")
    public List<String> search(@Body GrafanaSearch grafanaSearch) throws Exception {
        Object result;
        Preconditions.checkArgument((grafanaSearch != null && StringUtils.isNotBlank((CharSequence)grafanaSearch.getTarget()) ? 1 : 0) != 0, (Object)"illegal args at grafana search target.");
        String target = this.formatTarget(grafanaSearch.getTarget());
        String[] key = GrafanaUtils.getKey(target);
        List<String> metrics = GrafanaUtils.getMetrics().get(key[1]);
        if (NullUtil.isNotEmpty(metrics)) {
            return metrics;
        }
        GrafanaVariable variable = GrafanaUtils.getVariables().get(key[0]);
        if (variable == null) {
            logger.error(String.format("can not get grafana variable config with target %s", target));
            return Collections.emptyList();
        }
        List parameters = variable.getQuery().getParameters();
        Object[] args = new String[parameters.size()];
        String[] variables = target.split(GrafanaUtils.getDelimiter(target));
        if (parameters != null) {
            args = (String[])parameters.stream().sorted(Comparator.comparing(GrafanaVariableParameter::getArgIndex)).map(p -> variables[p.getTargetIndex()]).toArray(String[]::new);
        }
        try {
            Object service = this.context.get(variable.getQuery().getBean());
            Class[] types = new Class[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                types[i] = String.class;
            }
            Method method = service.getClass().getMethod(variable.getQuery().getMethod(), types);
            result = method.invoke(service, args);
        }
        catch (Exception e) {
            throw new ServiceException(500, "grafana query variable error. caused by: " + e.getCause(), (Throwable)e);
        }
        GrafanaVariableResult resultFormat = variable.getResult();
        return this.formateResult(result, resultFormat.getFormat(), resultFormat.getType(), resultFormat.getDelimiter());
    }

    @Path(value="getRedirectUrl")
    public Response getRedirectUrl(@QueryParam(value="uid") Object uid) throws Exception {
        Preconditions.checkArgument((uid != null ? 1 : 0) != 0, (Object)"invalid arguments, uid can not be null.");
        return Responses.success((Object)GrafanaUtils.getUrls().get(uid));
    }

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    private String formatTarget(String target) {
        return target.replaceAll("\\\\", "");
    }

    private List<String> formateResult(Object result, String format, String type, String delimiter) {
        if (result == null) {
            return null;
        }
        if ("string".equalsIgnoreCase(type)) {
            return Collections.singletonList(((ArrayList)result).stream().map(a -> GrafanaUtils.getResult(a, format)).collect(Collectors.joining(delimiter == null ? "" : delimiter)));
        }
        return ((ArrayList)result).stream().map(a -> GrafanaUtils.getResult(a, format)).collect(Collectors.toList());
    }

    public void clean() {
        this.context = null;
    }
}

