/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.chart;

import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import org.joyqueue.exception.ValidationException;
import org.joyqueue.handler.routing.command.CommandSupport;
import org.joyqueue.model.ListQuery;
import org.joyqueue.model.domain.Metric;
import org.joyqueue.model.query.QMetric;
import org.joyqueue.service.MetricService;

public class MetricCommand
extends CommandSupport<Metric, MetricService, QMetric> {
    @Override
    @Path(value="add")
    public Response add(@Body Metric metric) throws Exception {
        if (((MetricService)this.service).findByCode(metric.getCode()) != null) {
            throw new ValidationException(100, "code|\u5df2\u7ecf\u5b58\u5728");
        }
        if (((MetricService)this.service).findByAliasCode(metric.getAliasCode()) != null) {
            throw new ValidationException(100, "aliasCode|\u5df2\u7ecf\u5b58\u5728");
        }
        return super.add(metric);
    }

    @Override
    @Path(value="update")
    public Response update(@QueryParam(value="id") Long id, @Body Metric metric) throws Exception {
        if (((MetricService)this.service).findByCode(metric.getCode()) == null) {
            throw new ValidationException(200, "code|\u4e0d\u5b58\u5728");
        }
        return super.update(id, metric);
    }

    @Path(value="findAll")
    public Response findAll() throws Exception {
        return Responses.success((Object)((MetricService)this.service).findByQuery(new ListQuery((Object)new QMetric())));
    }
}

