/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.monitor;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.model.BrokerMetadata;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Broker;
import org.joyqueue.model.domain.BrokerMonitorRecord;
import org.joyqueue.model.domain.Subscribe;
import org.joyqueue.model.query.QMonitor;
import org.joyqueue.model.query.QPartitionGroupMonitor;
import org.joyqueue.monitor.BrokerMonitorInfo;
import org.joyqueue.monitor.BrokerStartupInfo;
import org.joyqueue.service.BrokerManageService;
import org.joyqueue.service.BrokerMessageService;
import org.joyqueue.service.BrokerMonitorService;
import org.joyqueue.service.BrokerService;
import org.joyqueue.service.BrokerTopicMonitorService;
import org.joyqueue.service.CoordinatorMonitorService;
import org.joyqueue.toolkit.io.Directory;
import org.joyqueue.util.NullUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerMonitorCommand
implements Command<Response>,
Poolable {
    private static final Logger logger = LoggerFactory.getLogger(BrokerMonitorCommand.class);
    @Value
    private BrokerMonitorService brokerMonitorService;
    @Value
    private BrokerMessageService brokerMessageService;
    @Value
    private BrokerManageService brokerManageService;
    @Value
    private CoordinatorMonitorService coordinatorMonitorService;
    @Value
    private BrokerTopicMonitorService brokerTopicMonitorService;
    @Value
    private BrokerService brokerService;

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    @Path(value="find")
    public Response find(@Body Subscribe subscribe) {
        BrokerMonitorRecord record;
        try {
            record = this.brokerMonitorService.find(subscribe, true);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
        return Responses.success((Object)record);
    }

    @Path(value="findOnPartition")
    public Response findMonitorOnPartition(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findMonitorOnPartition(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findOnPartitionGroups")
    public Response findMonitorOnPartitionGroups(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findMonitorOnPartitionGroupsForTopicApp(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findOnBroker")
    public Response findMonitorOnBroker(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findMonitorOnBroker(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findConnectionOnBroker")
    public Response findConnectionOnBroker(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findConnectionOnBroker(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findClient")
    public Response findClients(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findClients(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="brokerMonitor")
    public Response brokerMonitor(@PageQuery QPageQuery<QMonitor> qPageQuery) {
        try {
            PageResult pageResult = this.brokerTopicMonitorService.queryTopicsMointor(qPageQuery);
            return new Response((Object)pageResult.getResult(), (Object)pageResult.getPagination());
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="partitionGroupMonitor")
    public Response partitionGroupMonitor(@PageQuery QPageQuery<QMonitor> qPageQuery) {
        try {
            PageResult pageResult = this.brokerTopicMonitorService.queryTopicsPartitionMointor(qPageQuery);
            return new Response((Object)pageResult.getResult(), (Object)pageResult.getPagination());
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="brokerConnectionsMonitor")
    public Response brokerConnectionsMonitor(@PageQuery QPageQuery<QMonitor> qPageQuery) {
        try {
            PageResult pageResult = this.brokerTopicMonitorService.queryClientConnectionDetail(qPageQuery);
            return new Response((Object)pageResult.getResult(), (Object)pageResult.getPagination());
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findMonitorOnPartitionGroupsForTopicApp")
    public Response findMonitorOnPartitionsGroupsForTopicApp(@Body Subscribe subscribe) {
        try {
            List record = this.brokerMonitorService.findMonitorOnPartitionGroupsForTopicApp(subscribe);
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findMonitorOnPartitionGroupDetailForTopicApp")
    public Response findMonitorOnPartitionGroupDetailForTopicApp(@Body QPartitionGroupMonitor partitionGroupMonitor) {
        try {
            List record = this.brokerMonitorService.findMonitorOnPartitionGroupDetailForTopicApp(partitionGroupMonitor.getSubscribe(), partitionGroupMonitor.getPartitionGroup());
            return Responses.success((Object)record);
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="previewMessage")
    public Response previewMessage(@Body Subscribe subscribe) {
        int defaultCount = 10;
        List messages = this.brokerMessageService.previewMessage(subscribe, defaultCount);
        return Responses.success((Object)messages);
    }

    @Path(value="viewMessage")
    public Response viewMessage(@Body Subscribe subscribe, @QueryParam(value="partition") String partition, @QueryParam(value="index") String index, @QueryParam(value="timestamp") String timestamp) {
        int defaultCount = 10;
        if (StringUtils.isNotEmpty((CharSequence)timestamp) && StringUtils.isEmpty((CharSequence)index)) {
            Long indexByTime = this.brokerMessageService.getPartitionIndexByTime(subscribe, partition, timestamp);
            index = String.valueOf(indexByTime);
        }
        List messages = this.brokerMessageService.viewMessage(subscribe, partition, index, defaultCount);
        return Responses.success((Object)messages);
    }

    @Path(value="archiveState")
    public Response archiveState(@Body org.joyqueue.domain.Broker broker) {
        try {
            return Responses.success((Object)this.brokerMonitorService.findArchiveState(broker.getIp(), broker.getMonitorPort()));
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="coordinator")
    public Response coordinator(@Body Subscribe subscribe) {
        try {
            if (NullUtil.isEmpty((Object)subscribe.getApp())) {
                return Responses.error((int)ErrorCode.BadRequest.getCode(), (String)"app \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return Responses.success((Object)this.coordinatorMonitorService.findCoordinatorInfo(subscribe));
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="coordinatorGroupMember")
    public Response coordinatorGroupMember(@Body Subscribe subscribe) {
        try {
            if (NullUtil.isEmpty((Object)subscribe.getApp()) || NullUtil.isEmpty((Object)subscribe.getTopic())) {
                return Responses.error((int)ErrorCode.BadRequest.getCode(), (String)"app \u548c topic \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return Responses.success((Object)this.coordinatorMonitorService.findCoordinatorGroupMember(subscribe));
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="coordinatorGroupExpiredMember")
    public Response coordinatorGroupExpiredMember(@Body Subscribe subscribe) {
        try {
            if (NullUtil.isEmpty((Object)subscribe.getApp()) || NullUtil.isEmpty((Object)subscribe.getTopic())) {
                return Responses.error((int)ErrorCode.BadRequest.getCode(), (String)"app \u548c topic \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return Responses.success((Object)this.coordinatorMonitorService.findExpiredCoordinatorGroupMember(subscribe));
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findPartitionGroupMetric")
    public Response findPartitionGroupMetric(@Body QPartitionGroupMonitor partitionGroupMonitor) {
        try {
            if (NullUtil.isEmpty((Object)partitionGroupMonitor.getPartitionGroup()) || NullUtil.isEmpty((Object)partitionGroupMonitor.getSubscribe())) {
                return Responses.error((int)ErrorCode.BadRequest.getCode(), (String)"app \u548c topic \u4e0d\u80fd\u4e3a\u7a7a");
            }
            Subscribe subscribe = partitionGroupMonitor.getSubscribe();
            int groupNo = partitionGroupMonitor.getPartitionGroup();
            return Responses.success((Object)this.brokerMonitorService.findPartitionGroupMetric(subscribe.getNamespace().getCode(), subscribe.getTopic().getCode(), Integer.valueOf(groupNo)));
        }
        catch (Exception e) {
            logger.error("query broker monitor info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findBrokerDetail")
    public Response findBrokerDetail(@QueryParam(value="brokerId") Long brokerId) {
        BrokerMonitorInfo brokerMonitorInfo = this.brokerTopicMonitorService.findBrokerMonitor(brokerId);
        return Responses.success((Object)brokerMonitorInfo);
    }

    @Path(value="startInfo")
    public Response startInfo(@QueryParam(value="brokerId") Long brokerId) throws Exception {
        try {
            BrokerStartupInfo brokerStartupInfo = this.brokerTopicMonitorService.getStartupInfo(brokerId);
            return Responses.success((Object)brokerStartupInfo);
        }
        catch (Exception e) {
            logger.error("query broker start info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="storeTreeView")
    public Response storeTreeView(@QueryParam(value="brokerId") Integer brokerId, @QueryParam(value="recursive") boolean recursive) throws Exception {
        try {
            Directory directory = this.brokerManageService.storeTreeView(brokerId.intValue(), recursive);
            return Responses.success((Object)directory);
        }
        catch (Exception e) {
            logger.error("query broker store tree view error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="garbageFile")
    public Response deleteGarbageFile(@QueryParam(value="brokerId") Integer brokerId, @QueryParam(value="fileName") String fileName, @QueryParam(value="retain") boolean retain) throws Exception {
        try {
            boolean result = this.brokerManageService.deleteGarbageFile(brokerId.intValue(), fileName, retain);
            return Responses.success((Object)result);
        }
        catch (Exception e) {
            logger.error("query broker store tree view error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="findBrokerMetadata")
    public Response findBrokerMetadata(@QueryParam(value="brokerId") Long brokerId, @QueryParam(value="topicFullName") String topicFullName, @QueryParam(value="group") Integer group) throws Exception {
        Broker broker = (Broker)this.brokerService.findById((Object)Integer.valueOf(String.valueOf(brokerId)));
        if (broker == null) {
            String msg = String.format("can not find broker with id %s", brokerId);
            logger.error(msg);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)msg);
        }
        try {
            BrokerMetadata brokerMetadata = this.brokerMonitorService.findBrokerMetadata(broker, topicFullName, group.intValue());
            return Responses.success((Object)brokerMetadata);
        }
        catch (Exception e) {
            logger.error("query broker metadata error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    public void clean() {
        this.brokerMonitorService = null;
        this.brokerMessageService = null;
        this.coordinatorMonitorService = null;
    }
}

