/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.monitor;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.OperLog;
import org.joyqueue.model.domain.PartitionOffset;
import org.joyqueue.model.domain.ResetOffsetInfo;
import org.joyqueue.model.domain.Subscribe;
import org.joyqueue.monitor.PartitionLeaderAckMonitorInfo;
import org.joyqueue.service.ConsumeOffsetService;
import org.joyqueue.service.OperLogService;
import org.joyqueue.util.LocalSession;
import org.joyqueue.util.NullUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeOffsetCommand
implements Command<Response>,
Poolable {
    private static final Logger logger = LoggerFactory.getLogger(ConsumeOffsetCommand.class);
    @Value(nullable=false)
    private ConsumeOffsetService consumeOffsetService;
    @Value(nullable=false)
    private OperLogService operLogService;

    public Response execute() throws Exception {
        throw new UnsupportedOperationException("unsupported");
    }

    @Path(value="offsets")
    public Response offsets(@Body Subscribe subscribe) {
        try {
            return Responses.success((Object)this.consumeOffsetService.offsets(subscribe));
        }
        catch (Exception e) {
            logger.error("query consumer offset info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    private void logOperation(String topic, String app, String operation) {
        OperLog log = new OperLog();
        log.setIdentity(topic);
        Long id = LocalSession.getSession().getUser().getId();
        String code = LocalSession.getSession().getUser().getCode();
        log.setCreateBy(new Identity(id, code));
        log.setCreateTime(new Date());
        log.setUpdateBy(new Identity(id, code));
        log.setUpdateTime(new Date());
        log.setType(Integer.valueOf(OperLog.Type.CONSUMER.value()));
        log.setOperType(Integer.valueOf(OperLog.OperType.UPDATE.value()));
        log.setTarget("topic: " + topic + " app: " + app + " operation: " + operation);
        this.operLogService.add((BaseModel)log);
    }

    @Path(value="resetBound")
    public Response offsetBound(@Body Subscribe subscribe, @QueryParam(value="location") String location) {
        PartitionOffset.Location loc = PartitionOffset.Location.valueOf((String)location);
        ArrayList<PartitionOffset> partitionOffsets = new ArrayList<PartitionOffset>();
        List partitionAckMonitorInfos = this.consumeOffsetService.offsets(subscribe);
        for (PartitionLeaderAckMonitorInfo p : partitionAckMonitorInfos) {
            if (!p.isLeader()) continue;
            PartitionOffset partitionOffset = new PartitionOffset();
            partitionOffset.setPartition(p.getPartition());
            if (loc == PartitionOffset.Location.MAX) {
                partitionOffset.setOffset(p.getRightIndex());
            } else {
                partitionOffset.setOffset(p.getLeftIndex());
            }
            partitionOffsets.add(partitionOffset);
            this.logOperation(subscribe.getTopic().getCode(), subscribe.getApp().getCode(), "resetBound: " + partitionOffset);
        }
        boolean result = this.consumeOffsetService.resetOffset(subscribe, partitionOffsets);
        return result ? Responses.success((Object)"success") : Responses.error((int)ErrorCode.ServiceError.getCode(), (String)"reset failed");
    }

    @Path(value="resetByTime")
    public Response resetByTime(@Body Subscribe subscribe, @QueryParam(value="timestamp") String timestamp) {
        try {
            Long time = Long.valueOf(timestamp);
            this.logOperation(subscribe.getTopic().getCode(), subscribe.getApp().getCode(), "resetByTime: " + timestamp);
            boolean result = this.consumeOffsetService.resetOffset(subscribe, time.longValue());
            return result ? Responses.success((Object)"success") : Responses.error((int)ErrorCode.ServiceError.getCode(), (String)"reset failed");
        }
        catch (Exception e) {
            logger.error("query consumer offset info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="resetPartition")
    public Response resetPartition(@Body Subscribe subscribe, @QueryParam(value="partition") String partition, @QueryParam(value="offset") String offset) {
        try {
            if (NullUtil.isEmpty((String)partition) || NullUtil.isEmpty((String)offset)) {
                return Responses.error((int)ErrorCode.BadRequest.getCode(), (String)"partition and offset can't be null");
            }
            this.logOperation(subscribe.getTopic().getCode(), subscribe.getApp().getCode(), "resetPartition: partition=" + partition + ", offset=" + offset);
            boolean result = this.consumeOffsetService.resetOffset(subscribe, Short.valueOf(partition).shortValue(), Long.valueOf(offset).longValue());
            return result ? Responses.success((Object)"success") : Responses.error((int)ErrorCode.ServiceError.getCode(), (String)"reset failed");
        }
        catch (Exception e) {
            logger.error("query consumer offset info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    @Path(value="reset")
    public Response resetOffsets(@Body ResetOffsetInfo offsetInfo) {
        try {
            this.logOperation(offsetInfo.getSubscribe().getTopic().getCode(), offsetInfo.getSubscribe().getApp().getCode(), "resetOffsets: " + offsetInfo.getPartitionOffsets());
            boolean result = this.consumeOffsetService.resetOffset(offsetInfo.getSubscribe(), offsetInfo.getPartitionOffsets());
            return result ? Responses.success((Object)"success") : Responses.error((int)ErrorCode.ServiceError.getCode(), (String)"reset failed");
        }
        catch (Exception e) {
            logger.error("query consumer offset info error.", (Throwable)e);
            return Responses.error((int)ErrorCode.NoTipError.getCode(), (int)ErrorCode.NoTipError.getStatus(), (String)e.getMessage());
        }
    }

    public void clean() {
    }
}

