/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.monitor;

import com.google.common.collect.Lists;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Consumer;
import org.joyqueue.model.domain.ConsumerConfig;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QConsumer;
import org.joyqueue.nsr.ConsumerNameServerService;
import org.joyqueue.service.ApplicationService;
import org.joyqueue.service.ApplicationUserService;
import org.joyqueue.service.ConsumerService;
import org.joyqueue.service.TopicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCommand
extends NsrCommandSupport<Consumer, ConsumerService, QConsumer> {
    private final Logger logger = LoggerFactory.getLogger(ConsumerCommand.class);
    @Value(nullable=false)
    private ApplicationService applicationService;
    @Value(nullable=false)
    private TopicService topicService;
    @Value(nullable=false)
    private ConsumerNameServerService consumerNameServerService;
    @Value(nullable=false)
    private ApplicationUserService applicationUserService;

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QConsumer> qPageQuery) throws Exception {
        Consumer consumer;
        Iterator iterator;
        QConsumer query = (QConsumer)qPageQuery.getQuery();
        List consumers = Collections.emptyList();
        if (query.getApp() != null) {
            consumers = ((ConsumerService)this.service).findByApp(query.getApp().getCode());
        } else if (query.getTopic() != null) {
            consumers = ((ConsumerService)this.service).findByTopic(query.getTopic().getCode(), query.getTopic().getNamespace().getCode());
        }
        if (CollectionUtils.isNotEmpty(consumers) && qPageQuery.getQuery() != null && StringUtils.isNotBlank((CharSequence)((QConsumer)qPageQuery.getQuery()).getKeyword())) {
            consumers = Lists.newArrayList((Iterable)consumers);
            iterator = consumers.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                if (consumer.getTopic().getCode().equals(((QConsumer)qPageQuery.getQuery()).getKeyword())) continue;
                iterator.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)consumers) && this.session.getRole() != User.UserRole.ADMIN.value()) {
            iterator = consumers.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                if (this.applicationUserService.findByUserApp(this.session.getCode(), consumer.getApp().getCode().split("\\.")[0]) != null) continue;
                iterator.remove();
            }
        }
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(consumers.size());
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(consumers);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Override
    @Path(value="add")
    public Response add(@Body Consumer consumer) throws Exception {
        Consumer currentConsumer = ((ConsumerService)this.service).findByTopicAppGroup(consumer.getTopic().getNamespace().getCode(), consumer.getTopic().getCode(), consumer.getApp().getCode(), consumer.getSubscribeGroup());
        if (currentConsumer != null) {
            throw new ConfigException(ErrorCode.BadRequest, "consumer already exists!");
        }
        return super.add(consumer);
    }

    @Override
    @Path(value="delete")
    public Response delete(@QueryParam(value="id") String id) throws Exception {
        Consumer consumer = (Consumer)((ConsumerService)this.service).findById((Object)id);
        int count = ((ConsumerService)this.service).delete((Object)consumer);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success();
    }

    @Path(value="configAddOrUpdate")
    public Response configAddOrUpdate(@Body ConsumerConfig config) throws Exception {
        if (config != null) {
            Consumer consumer = (Consumer)((ConsumerService)this.service).findById((Object)config.getConsumerId());
            consumer.setConfig(config);
            ((ConsumerService)this.service).update((Object)consumer);
        }
        return Responses.success();
    }

    @Path(value="findAllSubscribeGroups")
    public Response findAllSubscribeGroups() throws Exception {
        return Responses.success((Object)((ConsumerService)this.service).findAllSubscribeGroups());
    }

    @Path(value="findAppsByTopic")
    public Response findAppsByTopic(@QueryParam(value="topic") String topic) throws Exception {
        return Responses.success((Object)((ConsumerService)this.service).findAppsByTopic(topic));
    }
}

