/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.monitor;

import com.google.common.collect.Lists;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.PartitionGroupWeight;
import org.joyqueue.model.domain.Producer;
import org.joyqueue.model.domain.ProducerConfig;
import org.joyqueue.model.domain.TopicPartitionGroup;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QProducer;
import org.joyqueue.nsr.ProducerNameServerService;
import org.joyqueue.service.ApplicationService;
import org.joyqueue.service.ApplicationUserService;
import org.joyqueue.service.ProducerService;
import org.joyqueue.service.TopicPartitionGroupService;
import org.joyqueue.service.TopicService;
import org.joyqueue.util.NullUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerCommand
extends NsrCommandSupport<Producer, ProducerService, QProducer> {
    private final Logger logger = LoggerFactory.getLogger(ProducerCommand.class);
    @Value(nullable=false)
    private ApplicationService applicationService;
    @Value(nullable=false)
    private TopicService topicService;
    @Value(nullable=false)
    private TopicPartitionGroupService topicPartitionGroupService;
    @Value(nullable=false)
    protected ProducerNameServerService producerNameServerService;
    @Value(nullable=false)
    private ApplicationUserService applicationUserService;

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QProducer> qPageQuery) throws Exception {
        Producer producer;
        Iterator iterator;
        QProducer query = (QProducer)qPageQuery.getQuery();
        List producers = Collections.emptyList();
        if (query.getApp() != null) {
            producers = ((ProducerService)this.service).findByApp(query.getApp().getCode());
        } else if (query.getTopic() != null) {
            producers = ((ProducerService)this.service).findByTopic(query.getTopic().getNamespace().getCode(), query.getTopic().getCode());
        }
        if (CollectionUtils.isNotEmpty(producers) && qPageQuery.getQuery() != null && StringUtils.isNotBlank((CharSequence)((QProducer)qPageQuery.getQuery()).getKeyword())) {
            producers = Lists.newArrayList((Iterable)producers);
            iterator = producers.iterator();
            while (iterator.hasNext()) {
                producer = (Producer)iterator.next();
                if (producer.getTopic().getCode().equals(((QProducer)qPageQuery.getQuery()).getKeyword())) continue;
                iterator.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)producers) && this.session.getRole() != User.UserRole.ADMIN.value()) {
            iterator = producers.iterator();
            while (iterator.hasNext()) {
                producer = (Producer)iterator.next();
                if (this.applicationUserService.findByUserApp(this.session.getCode(), producer.getApp().getCode()) != null) continue;
                iterator.remove();
            }
        }
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(producers.size());
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(producers);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="query-by-topic")
    public Response queryByTopic(@Body QProducer qProducer) throws Exception {
        if (qProducer.getTopic() == null || qProducer.getTopic().getCode() == null) {
            return Responses.error((int)400, (String)"Empty topic!");
        }
        String namespace = null;
        String topic = qProducer.getTopic().getCode();
        if (null != qProducer.getTopic().getNamespace()) {
            namespace = qProducer.getTopic().getNamespace().getCode();
        }
        List producers = ((ProducerService)this.service).findByTopic(namespace, topic);
        return Responses.success((Object)producers);
    }

    @Override
    @Path(value="delete")
    public Response delete(@QueryParam(value="id") String id) throws Exception {
        Producer producer = (Producer)((ProducerService)this.service).findById((Object)id);
        int count = ((ProducerService)this.service).delete((Object)producer);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success();
    }

    @Path(value="weight")
    public Response findPartitionGroupWeight(@QueryParam(value="id") String id) throws Exception {
        Producer producer = (Producer)((ProducerService)this.service).findById((Object)id);
        ArrayList<PartitionGroupWeight> currentWeights = new ArrayList<PartitionGroupWeight>();
        if (!NullUtil.isEmpty((Object)producer)) {
            ProducerConfig producerConfig = producer.getConfig();
            Map weights = producerConfig.weights();
            List topicPartitionGroups = this.topicPartitionGroupService.findByTopic(producer.getNamespace(), producer.getTopic());
            for (TopicPartitionGroup p : topicPartitionGroups) {
                Short weightVal = 0;
                if (!NullUtil.isEmpty((Object)weights) && weights.get(String.valueOf(p.getGroupNo())) != null) {
                    weightVal = (Short)weights.get(String.valueOf(p.getGroupNo()));
                }
                PartitionGroupWeight weight = new PartitionGroupWeight();
                weight.setGroupNo(String.valueOf(p.getGroupNo()));
                weight.setWeight(weightVal);
                currentWeights.add(weight);
            }
        }
        return Responses.success(currentWeights);
    }
}

