/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.monitor;

import com.google.common.base.Preconditions;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import javax.validation.constraints.NotNull;
import org.joyqueue.handler.annotation.Operator;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.Producer;
import org.joyqueue.model.domain.ProducerConfig;
import org.joyqueue.service.ProducerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerConfigAddOrUpdateCommand
implements Command<Response>,
Poolable {
    private final Logger logger = LoggerFactory.getLogger(ProducerConfigAddOrUpdateCommand.class);
    @Value(nullable=false)
    protected ProducerService producerService;
    @Body(type=Body.BodyType.JSON)
    @NotNull
    protected ProducerConfig producerConfig;
    @Operator
    protected Identity operator;

    public String type() {
        return "addOrUpdateProducerConfig";
    }

    public Response execute() throws Exception {
        Preconditions.checkArgument((null != this.producerConfig ? 1 : 0) != 0, (Object)"invalid argument");
        Producer producer = (Producer)this.producerService.findById((Object)this.producerConfig.getProducerId());
        producer.setConfig(this.producerConfig);
        return Responses.success((Object)this.producerService.update((Object)producer));
    }

    public void clean() {
        this.producerConfig = null;
    }
}

