/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.retry;

import com.google.common.base.Strings;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.Command;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.CRequest;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.pool.Poolable;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.joyqueue.domain.ConsumeRetry;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.handler.annotation.Operator;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.util.RetryUtils;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.ApplicationUser;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.Retry;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QRetry;
import org.joyqueue.server.retry.model.RetryQueryCondition;
import org.joyqueue.service.ApplicationUserService;
import org.joyqueue.service.ConsumerService;
import org.joyqueue.service.RetryService;
import org.joyqueue.toolkit.time.SystemClock;
import org.joyqueue.util.LocalSession;
import org.joyqueue.util.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RetryCommand
implements Command<Response>,
Poolable {
    private Logger logger = LoggerFactory.getLogger(RetryCommand.class);
    @CRequest
    private HttpServerRequest request;
    @Operator
    protected Identity operator;
    @Value(nullable=false)
    private ConsumerService consumerService;
    @Value(nullable=false)
    protected RetryService retryService;
    @Autowired
    private ApplicationUserService applicationUserService;

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QRetry> qPageQuery) throws Exception {
        if (qPageQuery == null || qPageQuery.getQuery() == null || Strings.isNullOrEmpty((String)((QRetry)qPageQuery.getQuery()).getTopic()) || Strings.isNullOrEmpty((String)((QRetry)qPageQuery.getQuery()).getApp())) {
            return Responses.error((int)400, (String)"app,topic,status \u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageResult pageResult = this.retryService.findByQuery(qPageQuery);
        return Responses.success((Object)pageResult.getPagination(), (List)pageResult.getResult());
    }

    @Path(value="recovery")
    public Response recovery(@QueryParam(value="id") Long id, @QueryParam(value="topic") String topic) throws Exception {
        ConsumeRetry retry = this.retryService.getDataById(id, topic);
        if (retry != null && (retry.getStatus() == Retry.StatusEnum.RETRY_DELETE.getValue() || retry.getStatus() == Retry.StatusEnum.RETRY_OUTOFDATE.getValue()) || retry.getStatus() == Retry.StatusEnum.RETRY_SUCCESS.getValue()) {
            retry.setExpireTime(RetryUtils.getExpireTime().getTime());
            retry.setRetryTime(RetryUtils.getNextRetryTime(new Date(), 0).getTime());
            retry.setRetryCount((short)0);
            retry.setUpdateTime(SystemClock.now());
            this.retryService.recover(retry);
            return Responses.success((Object)"\u6062\u590d\u6210\u529f");
        }
        return Responses.error((int)500, (String)"\u6062\u590d\u5931\u8d25");
    }

    @Path(value="download")
    public void download(@QueryParam(value="id") Long id, @QueryParam(value="topic") String topic) throws Exception {
        ConsumeRetry retry = this.retryService.getDataById(id, topic);
        if (retry != null) {
            HttpServerResponse response = this.request.response();
            byte[] data = retry.getData();
            if (data.length == 0) {
                throw new JoyQueueException("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a", 400);
            }
            String fileName = retry.getId() + ".txt";
            response.reset();
            BrokerMessage brokerMessage = Serializer.readBrokerMessage((ByteBuffer)ByteBuffer.wrap(data));
            String message = brokerMessage.getText();
            if (message == null) {
                message = "";
            }
            response.putHeader("Content-Disposition", "attachment;fileName=" + fileName).putHeader("content-type", "text/plain").putHeader("Content-Length", String.valueOf(message.getBytes().length));
            response.write(message, "UTF-8");
            response.end();
        }
    }

    @Path(value="delete")
    public Response delete(@QueryParam(value="id") Long id, @QueryParam(value="topic") String topic) throws Exception {
        ConsumeRetry retry = this.retryService.getDataById(id, topic);
        retry.setStatus((short)-1);
        retry.setUpdateBy(this.operator.getId().intValue());
        retry.setUpdateTime(SystemClock.now());
        this.retryService.delete(retry);
        return Responses.success();
    }

    @Path(value="batchDelete")
    public Response batchDelete(@Body QRetry qRetry) throws Exception {
        if (qRetry == null || Strings.isNullOrEmpty((String)qRetry.getTopic()) || Strings.isNullOrEmpty((String)qRetry.getApp()) || qRetry.getBeginTime() == null || qRetry.getEndTime() == null || qRetry.getStatus() == null) {
            return Responses.error((int)400, (String)"\u961f\u5217\u540d,\u6d88\u8d39\u8005,\u72b6\u6001,\u53d1\u9001\u5f00\u59cb\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        RetryQueryCondition retryQueryCondition = new RetryQueryCondition();
        retryQueryCondition.setTopic(qRetry.getTopic());
        retryQueryCondition.setApp(qRetry.getApp());
        retryQueryCondition.setBusinessId(qRetry.getBusinessId());
        retryQueryCondition.setStatus(qRetry.getStatus().shortValue());
        retryQueryCondition.setStartTime(qRetry.getBeginTime().getTime());
        retryQueryCondition.setEndTime(qRetry.getEndTime().getTime());
        this.retryService.batchDelete(retryQueryCondition, Long.valueOf(SystemClock.now()), this.operator.getId().intValue());
        return Responses.success();
    }

    @Path(value="batchRecovery")
    public Response batchRecovery(@QueryParam(value="ids") String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        for (String string : idList) {
        }
        return Responses.success();
    }

    @Path(value="isServerEnabled")
    public Response isServerEnabled() throws Exception {
        return Responses.success((Object)this.retryService.isServerEnabled());
    }

    private boolean hasSubscribe(String topic, String app) {
        return this.consumerService.findByTopicAppGroup(null, topic, app, null) != null;
    }

    private boolean hasPrivilege(String app) {
        User user = LocalSession.getSession().getUser();
        if (user == null) {
            return false;
        }
        if (user.getRole() == User.UserRole.ADMIN.value()) {
            return true;
        }
        ApplicationUser applicationUser = this.applicationUserService.findByUserApp(user.getCode(), app);
        return applicationUser != null;
    }

    public Response execute() throws Exception {
        return Responses.error((int)404, (int)404, (String)"Not Found");
    }

    public void clean() {
    }
}

