/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.topic;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.Query;
import org.joyqueue.model.domain.Broker;
import org.joyqueue.model.domain.PartitionGroupReplica;
import org.joyqueue.model.domain.TopicPartitionGroup;
import org.joyqueue.model.query.QBroker;
import org.joyqueue.model.query.QPartitionGroupReplica;
import org.joyqueue.service.BrokerService;
import org.joyqueue.service.PartitionGroupReplicaService;
import org.joyqueue.service.TopicPartitionGroupService;

public class PartitionGroupReplicaCommand
extends NsrCommandSupport<PartitionGroupReplica, PartitionGroupReplicaService, QPartitionGroupReplica> {
    @Value(nullable=false)
    private BrokerService brokerService;
    @Value(nullable=false)
    private TopicPartitionGroupService topicPartitionGroupService;

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QPartitionGroupReplica> qPageQuery) throws Exception {
        List queryResult;
        LinkedList<PartitionGroupReplica> partitionGroupReplicas = new LinkedList<PartitionGroupReplica>();
        QPartitionGroupReplica query = (QPartitionGroupReplica)qPageQuery.getQuery();
        if (query.getTopic() != null && (queryResult = ((PartitionGroupReplicaService)this.service).getByTopicAndGroup(query.getTopic().getCode(), query.getNamespace().getCode(), query.getGroupNo())) != null) {
            for (PartitionGroupReplica partitionGroupReplica : queryResult) {
                Broker broker = (Broker)this.brokerService.findById((Object)partitionGroupReplica.getBrokerId());
                if (broker == null) continue;
                partitionGroupReplica.setBroker(broker);
                partitionGroupReplicas.add(partitionGroupReplica);
            }
        }
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(partitionGroupReplicas.size());
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(partitionGroupReplicas);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="searchBrokerToScale")
    public Response toScaleSearch(@PageQuery QPageQuery<QPartitionGroupReplica> qPageQuery) throws Exception {
        QPartitionGroupReplica query = (QPartitionGroupReplica)qPageQuery.getQuery();
        List partitionGroupReplicas = ((PartitionGroupReplicaService)this.service).getByTopicAndGroup(query.getTopic().getCode(), query.getNamespace().getCode(), query.getGroupNo());
        QPageQuery brokerQuery = new QPageQuery(qPageQuery.getPagination(), (Query)new QBroker());
        ((QBroker)brokerQuery.getQuery()).setKeyword(((QPartitionGroupReplica)qPageQuery.getQuery()).getKeyword());
        PageResult brokerPage = this.brokerService.search(brokerQuery);
        ArrayList<Broker> brokers = new ArrayList<Broker>();
        if (CollectionUtils.isNotEmpty((Collection)partitionGroupReplicas)) {
            for (Broker broker : brokerPage.getResult()) {
                boolean isMatch = false;
                for (PartitionGroupReplica partitionGroupReplica : partitionGroupReplicas) {
                    if ((long)partitionGroupReplica.getBrokerId() != broker.getId()) continue;
                    isMatch = true;
                    break;
                }
                if (isMatch) continue;
                brokers.add(broker);
            }
        } else {
            brokers.addAll(brokerPage.getResult());
        }
        return Responses.success((Object)brokerPage.getPagination(), brokers);
    }

    @Path(value="searchBrokerToAddNew")
    public Response toAddNewPartitionGroupSearch(@PageQuery QPageQuery<QPartitionGroupReplica> qPageQuery) throws Exception {
        QPageQuery brokerQuery = new QPageQuery(qPageQuery.getPagination(), (Query)new QBroker());
        PageResult brokerPage = this.brokerService.search(brokerQuery);
        return Responses.success((Object)brokerPage.getPagination(), (List)brokerPage.getResult());
    }

    @Override
    @Path(value="add")
    public Response add(@Body PartitionGroupReplica model) throws Exception {
        TopicPartitionGroup group = this.topicPartitionGroupService.findByTopicAndGroup(model.getNamespace().getCode(), model.getTopic().getCode(), Integer.valueOf(model.getGroupNo()));
        if (group.getElectType().equals(TopicPartitionGroup.ElectType.raft.type())) {
            model.setRole(0);
        } else {
            model.setRole(2);
        }
        int count = ((PartitionGroupReplicaService)this.service).addWithNameservice(model, group);
        if (count <= 0) {
            throw new ConfigException(this.addErrorCode());
        }
        return Responses.success((Object)model);
    }

    @Path(value="delete")
    public Response delete(@Body PartitionGroupReplica partitionGroupReplica) throws Exception {
        PartitionGroupReplica replica = (PartitionGroupReplica)((PartitionGroupReplicaService)this.service).findById((Object)partitionGroupReplica.getId());
        int count = ((PartitionGroupReplicaService)this.service).removeWithNameservice(replica, this.topicPartitionGroupService.findByTopicAndGroup(replica.getNamespace().getCode(), replica.getTopic().getCode(), Integer.valueOf(replica.getGroupNo())));
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success((Object)replica);
    }

    @Path(value="leader")
    public Response leaderChange(@Body PartitionGroupReplica model) throws Exception {
        TopicPartitionGroup topicPartitionGroup = new TopicPartitionGroup();
        topicPartitionGroup.setTopic(model.getTopic());
        topicPartitionGroup.setNamespace(model.getNamespace());
        topicPartitionGroup.setLeader(Integer.valueOf(model.getBrokerId()));
        topicPartitionGroup.setGroupNo(model.getGroupNo());
        topicPartitionGroup.setOutSyncReplicas(model.getOutSyncReplicas());
        int count = this.topicPartitionGroupService.leaderChange(topicPartitionGroup);
        if (count <= 0) {
            throw new ConfigException(this.updateErrorCode());
        }
        return Responses.success();
    }
}

