/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.topic;

import com.google.common.base.Preconditions;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.List;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Topic;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QTopic;
import org.joyqueue.service.BrokerService;
import org.joyqueue.service.ConsumerService;
import org.joyqueue.service.ProducerService;
import org.joyqueue.service.TopicPartitionGroupService;
import org.joyqueue.service.TopicService;

public class TopicCommand
extends NsrCommandSupport<Topic, TopicService, QTopic> {
    @Value(nullable=false)
    protected BrokerService brokerService;
    @Value(nullable=false)
    protected TopicPartitionGroupService topicPartitionGroupService;
    @Value(nullable=false)
    protected ConsumerService consumerService;
    @Value(nullable=false)
    protected ProducerService producerService;

    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QTopic> qPageQuery) throws Exception {
        PageResult result = ((TopicService)this.service).search(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="addWithBrokerGroup")
    public Response addWithBrokerGroup(@Body Topic topic) throws Exception {
        if (topic == null || topic.getBrokerGroup() == null || topic.getBrokers() == null || topic.getBrokers().isEmpty()) {
            new ConfigException(ErrorCode.BadRequest);
        }
        if (topic.getReplica() > topic.getBrokers().size()) {
            topic.setReplica(topic.getBrokers().size());
        }
        ((TopicService)this.service).addWithBrokerGroup(topic, topic.getBrokerGroup(), topic.getBrokers(), this.operator);
        return Responses.success((Object)topic);
    }

    @Override
    @Path(value="delete")
    public Response delete(@Body(type=Body.BodyType.TEXT) String id) throws Exception {
        return super.delete(id);
    }

    @Path(value="/api/mqtt/topic/add")
    public Response addTopic(@Body Topic topic) throws Exception {
        List brokerList;
        if (topic == null || topic.getBrokerGroup() == null) {
            new ConfigException(ErrorCode.BadRequest);
        }
        Preconditions.checkArgument((null == (brokerList = this.brokerService.findByGroup(topic.getBrokerGroup().getId())) || brokerList.size() < 1 ? 1 : 0) != 0, (Object)(topic.getBrokerGroup().getCode() + "\u5206\u7ec4\u6682\u65f6\u65e0\u53ef\u7528broker"));
        topic.setBrokers(brokerList);
        if (topic.getReplica() > brokerList.size()) {
            topic.setReplica(brokerList.size());
        }
        ((TopicService)this.service).addWithBrokerGroup(topic, topic.getBrokerGroup(), topic.getBrokers(), this.operator);
        return Responses.success((Object)topic);
    }

    @Path(value="searchUnsubscribed")
    public Response searchUnsubscribed(@PageQuery QPageQuery<QTopic> qPageQuery) throws Exception {
        QTopic qTopic = (QTopic)qPageQuery.getQuery();
        if (qTopic == null) {
            throw new ConfigException(ErrorCode.BadRequest);
        }
        qTopic.setUserId(Long.valueOf(String.valueOf(this.session.getId())));
        qTopic.setAdmin(this.session.getRole() == User.UserRole.ADMIN.value() ? Boolean.TRUE : Boolean.FALSE);
        qTopic.setKeyword(qTopic.getKeyword() == null ? null : qTopic.getKeyword().trim());
        PageResult result = ((TopicService)this.service).findAppUnsubscribedByQuery(qPageQuery);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="getById")
    public Response getById(@Body Topic model) {
        try {
            return Responses.success((Object)((TopicService)this.service).findById((Object)model.getId()));
        }
        catch (Exception e) {
            return Responses.error((Throwable)e);
        }
    }
}

