/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.topic;

import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import java.util.Collections;
import java.util.List;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.routing.command.NsrCommandSupport;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Subscribe;
import org.joyqueue.model.domain.TopicPartitionGroup;
import org.joyqueue.model.query.QTopicPartitionGroup;
import org.joyqueue.service.TopicPartitionGroupService;

public class TopicPartitionGroupCommand
extends NsrCommandSupport<TopicPartitionGroup, TopicPartitionGroupService, QTopicPartitionGroup> {
    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QTopicPartitionGroup> qPageQuery) throws Exception {
        QTopicPartitionGroup query = (QTopicPartitionGroup)qPageQuery.getQuery();
        List topicPartitionGroups = Collections.emptyList();
        if (query.getTopic() != null) {
            topicPartitionGroups = ((TopicPartitionGroupService)this.service).findByTopic(query.getNamespace(), query.getTopic());
        }
        Pagination pagination = qPageQuery.getPagination();
        pagination.setTotalRecord(topicPartitionGroups.size());
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(topicPartitionGroups);
        return Responses.success((Object)result.getPagination(), (List)result.getResult());
    }

    @Path(value="findByTopic")
    public Response findByTopic(@Body Subscribe subscribe) throws Exception {
        return Responses.success((Object)((TopicPartitionGroupService)this.service).findByTopic(subscribe.getNamespace(), subscribe.getTopic()));
    }

    @Path(value="addPartition")
    public Response addPartition(@Body TopicPartitionGroup topicPartitionGroup) throws Exception {
        return Responses.success((Object)((TopicPartitionGroupService)this.service).addPartition(topicPartitionGroup));
    }

    @Path(value="removePartition")
    public Response removePartition(@Body TopicPartitionGroup topicPartitionGroup) throws Exception {
        return Responses.success((Object)((TopicPartitionGroupService)this.service).removePartition(topicPartitionGroup));
    }

    @Path(value="delete")
    public Response delete(@Body TopicPartitionGroup model) throws Exception {
        TopicPartitionGroup newModel = (TopicPartitionGroup)((TopicPartitionGroupService)this.service).findById((Object)model.getId());
        if (newModel == null) {
            throw new ConfigException(this.deleteErrorCode());
        }
        int count = ((TopicPartitionGroupService)this.service).delete((Object)newModel);
        if (count <= 0) {
            throw new ConfigException(this.deleteErrorCode());
        }
        return Responses.success();
    }
}

