/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.command.user;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.annotation.Body;
import com.jd.laf.web.vertx.annotation.Path;
import com.jd.laf.web.vertx.annotation.QueryParam;
import com.jd.laf.web.vertx.response.Response;
import com.jd.laf.web.vertx.response.Responses;
import org.joyqueue.handler.annotation.PageQuery;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.command.CommandSupport;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.User;
import org.joyqueue.model.query.QUser;
import org.joyqueue.service.UserService;

public class UserCommand
extends CommandSupport<User, UserService, QUser> {
    @Value(value="userDetail")
    protected User operator;

    @Override
    @Path(value="add")
    public Response add(@Body User model) throws Exception {
        model.setCreateBy(new Identity(Long.valueOf(-1L)));
        model.setUpdateBy(new Identity(Long.valueOf(-1L)));
        super.add(model);
        return Responses.success((Object)model);
    }

    @Override
    @Path(value="search")
    public Response pageQuery(@PageQuery QPageQuery<QUser> qPageQuery) throws Exception {
        if (qPageQuery.getQuery() == null) {
            qPageQuery.setQuery((Object)new QUser());
        }
        return super.pageQuery(qPageQuery);
    }

    @Override
    @Path(value="update")
    public Response update(@QueryParam(value="id") Long id, @Body User model) throws Exception {
        if (this.operator == null || this.operator.getRole() != User.UserRole.ADMIN.value()) {
            throw new ConfigException(ErrorCode.NoPrivilege);
        }
        return super.update(id, model);
    }

    @Path(value="getByCode")
    public Response getByCode(@QueryParam(value="code") String code) {
        return Responses.success((Object)((UserService)this.service).findByCode(code));
    }

    @Path(value="getByRole")
    public Response getByRole(@QueryParam(value="role") Integer role) {
        return Responses.success((Object)((UserService)this.service).findByRole(role.intValue()));
    }
}

