/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameter;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import java.util.Date;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.ApplicationToken;
import org.joyqueue.service.ApplicationService;
import org.joyqueue.service.ApplicationTokenService;

public class ValidateAppTokenHandler
extends ValidateHandler {
    @Value
    protected ApplicationService applicationService;
    @Value
    protected ApplicationTokenService applicationTokenService;

    public String type() {
        return "validateAppToken";
    }

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        Parameter header = parameter.header();
        String appCode = header.getString("application");
        String token = header.getString("token");
        if (appCode == null || appCode.isEmpty()) {
            throw new ConfigException(ErrorCode.BadRequest, "\u8bf7\u6c42\u5934\u6ca1\u6709\u5e94\u7528\u4ee3\u7801");
        }
        if (token == null || token.isEmpty()) {
            throw new ConfigException(ErrorCode.BadRequest, "\u8bf7\u6c42\u5934\u6ca1\u6709\u4ee4\u724c");
        }
        Application application = this.applicationService.findByCode(appCode);
        if (application == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists);
        }
        context.put("application", (Object)application);
        ApplicationToken applicationToken = this.applicationTokenService.findByAppAndToken(String.valueOf(application.getId()), token);
        if (applicationToken == null || !applicationToken.isEffective(new Date())) {
            throw new ConfigException(ErrorCode.InvalidToken);
        }
    }
}

