/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import javax.validation.constraints.NotNull;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.ApplicationUser;
import org.joyqueue.service.UserService;

public class ValidateAppUserOfApplicationHandler
extends ValidateHandler {
    @Value
    @NotNull
    protected UserService userService;

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        ApplicationUser user;
        Application application = (Application)context.get("application");
        Long appUserId = parameter.query().getLong("appUserId");
        Long userId = parameter.query().getLong("userId");
        ApplicationUser applicationUser = appUserId != null ? this.userService.findAppUserById(appUserId.longValue()) : (user = userId != null && application != null ? this.userService.findAppUserByAppIdAndUserId(application.getId(), userId.longValue()) : null);
        if (application == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists);
        }
        if (user == null) {
            throw new ConfigException(ErrorCode.AppUserNotExists);
        }
        if (user.getApplication().getId().longValue() != application.getId()) {
            throw new ConfigException(ErrorCode.NoPrivilege);
        }
        context.put("appUser", (Object)user);
    }

    public String type() {
        return "validateAppUserOfApplication";
    }
}

