/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameter;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.Identifier;
import org.joyqueue.service.ApplicationService;

public class ValidateApplicationHandler
extends ValidateHandler {
    @Value
    protected ApplicationService applicationService;

    public String type() {
        return "validateApplication";
    }

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        Parameter query = parameter.query();
        String value = query.getString("appId");
        value = value == null ? query.getString("appCode") : value;
        value = value == null ? query.getString("id") : value;
        Application application = (Application)context.get("application");
        if (application != null) {
            if (application.getCode().equals(value) || String.valueOf(application.getId()).equals(value)) {
                return;
            }
            throw new ConfigException(ErrorCode.NoPrivilege);
        }
        if (Character.isDigit(value.charAt(0))) {
            try {
                application = (Application)this.applicationService.findById(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (application == null) {
            if (Identifier.isIdentifier((String)value)) {
                application = this.applicationService.findByCode(value);
                if (application == null) {
                    throw new ConfigException(ErrorCode.ApplicationNotExists);
                }
            } else {
                throw new ConfigException(ErrorCode.ApplicationNotExists);
            }
        }
        context.put("application", (Object)application);
    }
}

