/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameter;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.service.ApplicationService;

public class ValidateApplicationOfHeaderHandler
extends ValidateHandler {
    @Value
    protected ApplicationService applicationService;

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        Parameter header = parameter.header();
        String appCode = header.getString("application");
        if (appCode == null || appCode.isEmpty()) {
            throw new ConfigException(ErrorCode.BadRequest, "\u8bf7\u6c42\u5934\u6ca1\u6709\u5e94\u7528\u4ee3\u7801");
        }
        Application application = this.applicationService.findByCode(appCode);
        if (application == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists);
        }
        context.put("application", (Object)application);
    }

    public String type() {
        return "validateAppOfHeader";
    }
}

