/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.User;
import org.joyqueue.service.UserService;

public class ValidateApplicationOwnerHandler
extends ValidateHandler {
    @Value
    protected UserService userService;

    public String type() {
        return "validateApplicationOwner";
    }

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        Application application = (Application)context.get("application");
        User user = (User)context.get("userDetail");
        if (application != null && (application.isOwner(user) || user.getRole() == User.UserRole.ADMIN.value())) {
            return;
        }
        throw new ConfigException(ErrorCode.NoPrivilege);
    }
}

